
/**

MemoryBus.java - Copyright 2003-2008 by Michael Kohn 

Part of the Jatari project.  This module falls under the GPL license.

1 2 1 2 The Naken Crew

Email: mike@mikekohn.net
  Web: http://www.mikekohn.net/

Memory/devices in the Atari are mirrored all over the place.. I only
took care of mirrored ROM so far.  Hopefully no software wants the TIA
or PIA mirrored.  This is really fucking disgusting.  I mean it was
probably caused by the way the address bus and chip select were wired,
but any programmer that took advantage of that should be shot.  Especially
since RAM and TIA sit in zero page.

Readable areas:
0x00 - 0x2c    : TIA
0x80 - 0xff    : PIA (ram)
0x280 - 0x297  : PIA IO/Timer
0xf000 - 0xffff: ROM

Writable areas:
0x00 - 0x0d    : TIA
0x80 - 0xff    : PIA (ram)
0x280 - 0x297  : PIA IO/Timer

*/

public class MemoryBus
{
TIA tia;
PIA pia;
ROM rom;

  public MemoryBus(String filename)
  {
    tia=new TIA();
    pia=new PIA();
    rom=new ROM(filename);
  }

  public void init()
  {
    tia.init();
  }

  /** Apply clock to bus.  MemoryBus should apply then route this clock 
      to all devices on the bus */

  public void clock()
  {
    tia.clock();
    pia.clock();
  }

  public void clock(int n)
  {
    tia.clock(n);
    pia.clock(n);
  }

/*
  // http://www.qotile.net/minidig/docs/2600_mem_map.txt
  // PUKE!
  private int address_decode(int addr)
  {
    if ((addr&0x1000)==0x1000)
    {
      return addr|0xf000;
    }

    return 0;
  }
*/

  /** read a memory out of memory. */

  public int read_mem(int addr)
  {
    if ((addr&0x1000)==0x1000)  // takes care of crappy mirrored mem
    {
      return rom.read_mem(addr&0x0fff);
    }
      else
    if (addr<=0x3f)
    {
      return tia.read_mem(addr&0x3f);
    }

    return pia.read_mem(addr);
  }

  /** Write value to memory. */

  public void write_mem(int addr, char value)
  {
/* DUH
    if ((addr&0x1000)==0x1000)  // takes care of crappy mirrored mem
    {
      rom.write_mem(addr&0x0fff,value);
    }
      else
*/
    if (addr<=0x3f)
    {
      tia.write_mem(addr&0x3f,value);
    }
      else
    if ((addr&0x1000)==0x0000)
    {
      pia.write_mem(addr,value);
    }
  }

  /** Increment memory value. */

  public void inc_mem(int addr)
  {
  int value;

    value=read_mem(addr);
    value++;
    value&=0xff;
    write_mem(addr,(char)value);
  }

  /** Decrement memory value. */

  public void dec_mem(int addr)
  {
  int value;

    value=read_mem(addr);
    value--;
    value&=0xff;
    write_mem(addr,(char)value);
  }
}


