
/**

PIA.java - Copyright 2003-2008 by Michael Kohn 

Part of the Jatari project.  This module falls under the GPL license.

1 2 1 2 The Naken Crew

Email: mike@mikekohn.net
  Web: http://www.mikekohn.net/

This is the PIA (6532) chip in the Atari.  It contains timers, ram,
and i/o information.

*/

public class PIA implements IO
{
public static final int TIM1T=1;
public static final int TIM8T=8;
public static final int TIM64T=64;
public static final int T1024T=1024;
public static final int TIM1T_S=0;
public static final int TIM8T_S=3;
public static final int TIM64T_S=6;
public static final int T1024T_S=10;
char[] riot=new char[8];
char[] ram=new char[128];
int prescale=TIM1T;
int prescale_s=TIM1T_S;
int intim=255;

  public PIA()
  {
    riot[0]=255;
  }

  /** Get memory address out of PIA */

  public char read_mem(int addr)
  {
    if (addr>=128 && addr<=255) return ram[addr-128];
    return riot[addr&0x07];
  }

  /** Set memory address in PIA */

  public void write_mem(int addr, char value)
  {
    if (addr>=128 && addr<=255)
    {
      ram[(addr&0xff)-128]=value;
      return;
    }

    if (addr>=0x294)
    {
      if (addr==0x294)
      {
        prescale=TIM1T;
        prescale_s=TIM1T_S;
      }
        else
      if (addr==0x295)
      {
        prescale=TIM8T;
        prescale_s=TIM8T_S;
      }
        else
      if (addr==0x296)
      {
        prescale=TIM64T;
        prescale_s=TIM64T_S;
      }
        else
      if (addr==0x297)
      {
        prescale=T1024T;
        prescale_s=T1024T_S;
      }

      intim=((value+1)*prescale)-1;
      riot[4]=value;

//System.out.println(addr+" "+(int)value+" "+intim+" "+((((int)value+1)*prescale)-1)+(int)prescale);
    }
      else
    if (addr<0x284)
    {
      riot[addr&0x07]=value;
    }
  }

  /** Apply clock pulse to PIA */

  public void clock()
  {
    intim--;

    if (intim<0)
    {
      intim=(prescale<<8)-1;
    }

    riot[4]=(char)(intim>>prescale_s);
  }

  /** Apply n clock pulses to PIA */

  public void clock(int n)
  {
    intim=intim-n;

    while(intim<0)  // gross, but shouldn't loop anyway
    {
      intim+=(prescale<<8);
    }

    riot[4]=(char)(intim>>prescale_s);
  }

  public void joystickAMove(int direction)
  {
    // right, left, down, up
    riot[0]^=4<<direction;
  }

  public void joystickAButton(boolean down)
  {
  }

  public void joystickBMove(int direction)
  {
    riot[0]^=direction;
  }

  public void joystickBButton(boolean down)
  {

  }

  public void diffultyA(boolean on)
  {

  }

  public void diffultyB(boolean on)
  {

  }
}


