
/**

TIA.java - Copyright 2003-2008 by Michael Kohn 

Part of the Jatari project.  This module falls under the GPL license.

1 2 1 2 The Naken Crew

Email: mike@mikekohn.net
  Web: http://www.mikekohn.net/

*/

public class TIA
{
Television tv;
// Hopefully the Java optimizer will compile these to nothing
private static final int VSYNC=0x00;
private static final int VBLANK=0x01;
private static final int WSYNC=0x02;
private static final int RSYNC=0x03;
private static final int NUSIZ0=0x04;
private static final int NUSIZ1=0x05;
private static final int COLUP0=0x06;
private static final int COLUP1=0x07;
private static final int COLUPF=0x08;
private static final int COLUBK=0x09;
private static final int CTRLPF=0x0a;
private static final int REFP0=0x0b;
private static final int REFP1=0x0c;
private static final int PF0=0x0d;
private static final int PF1=0x0e;
private static final int PF2=0x0f;
private static final int RESP0=0x10;
private static final int RESP1=0x11;
private static final int RESM0=0x12;
private static final int RESM1=0x13;
private static final int GRP0=0x1b;
private static final int GRP1=0x1c;
private static final int ENAM0=0x1d;
private static final int ENAM1=0x1e;
private static final int ENABL=0x1f;
private static final int HMP0=0x20;
private static final int HMP1=0x21;
private static final int HMM0=0x22;
private static final int HMM1=0x23;
private static final int HMBL=0x24;
private static final int VDELP0=0x25;
private static final int VDELP1=0x26;
private static final int VDELBL=0x27;
private static final int RESMP0=0x28;
private static final int RESMP1=0x29;
private static final int HMOVE=0x2a;
private static final int HMCLR=0x2b;
private static final int CXCLR=0x2c;
private static final int CXM0P=0x00;
private static final int CXM1P=0x01;
private static final int CXP0FB=0x02;
private static final int CXP1FB=0x03;
private static final int CXM0FB=0x04;
private static final int CXM1FB=0x05;
private static final int CXBLPF=0x06;
private static final int CXPPMM=0x07;
private static final int INPT4=0x0c;
private static final int INPT5=0x0d;
// char[] write_regs=new char[0x2d];
char[] write_regs=new char[0x100];  // jeez.. tards
char[] read_regs=new char[0xe];
char[] reverser;
int posx;
int wsync=0;
long playfield=0;
long pf_bit=0;
int player0_clocks=0;
int player0=0;
int player1_clocks=0;
int player1=0;

  public TIA()
  {
  int t;

    reverser=new char[256];
    for (t=0; t<256; t++)
    {
      reverser[t]=(char)(((t&0x01)<<7) | ((t&0x02)<<5) |
                         ((t&0x04)<<3) | ((t&0x08)<<1) |
                         ((t&0x10)>>1) | ((t&0x20)>>3) |
                         ((t&0x40)>>5) | ((t&0x80)>>7));
    }

    tv=new Television(320,192);
  }

  public void init()
  {
    tv.init();
    pf_bit=1;
    posx=0;
  }

  /** Calc playfield - calculates 20 bit * 2 register to draw.  TIA
      writes this register right to left across 160 pixels. */

  private void calc_playfield()
  {
    playfield=((write_regs[PF0]>>4)&0x0f)|
              (reverser[write_regs[PF1]]<<4)|
              (write_regs[PF2]<<12);

    if ((write_regs[CTRLPF]&1)==0)  // no mirror image
    {
      playfield|=playfield<<20;
    }
      else // mirror it
    {
      playfield|=((long)(reverser[write_regs[PF0]]&0x0f)<<36)|
                 (((long)write_regs[PF1])<<28)|
                 (reverser[write_regs[PF2]]<<20);
    }
  }


  /** Draw playfield foreground pixel */

  private boolean draw_playfield_fg()
  {
    if ((playfield&pf_bit)!=0)
    {
      if ((write_regs[CTRLPF]&4)==4)
      {
        if (posx<148)
        { tv.setColor(write_regs[COLUP0]); }
          else
        { tv.setColor(write_regs[COLUP1]); }

      }
        else
      { tv.setColor(write_regs[COLUPF]); }
    }

    return false;
  }

  private boolean draw_playfield_bg()
  {
    if ((playfield&pf_bit)==0)
    {
      tv.setColor(write_regs[COLUBK]);
      return true;
    }

    return false;
  }

  private boolean draw_player1()
  {
    if ((player0&0xf00)==0) return false;

    if ((player0&0x01)==1)
    {
      tv.setColor(write_regs[COLUP0]);
      return true;
    }

    return false;
  }

  private boolean draw_player2()
  {

    return false;
  }

  private boolean draw_ball()
  {
    if ((write_regs[ENABL]&0x01)==0) return false;

    return false;
  }

  /** Calculate the current pixel color */

  public void calc_pixel()
  {
    if (posx==68)
    {
        pf_bit=1; 
    }

    // figure out what to display

    if ((write_regs[CTRLPF]&4)==0)
    {
      if (draw_player1()==false)
      {
        if (draw_player2()==false)
        {
          if (draw_ball()==false)
          {
            if (draw_playfield_fg()==false)
            {
              draw_playfield_bg();
            }
          }
        }
      }
    }
      else
    {
      if (draw_playfield_fg()==false)
      {
        if (draw_ball()==false)
        {
          if (draw_player1()==false)
          {
            if (draw_player2()==false)
            {
              if (draw_ball()==false)
              {
                  draw_playfield_bg();
              }
            }
          }
        }
      }
    }

    posx++;

    if (((posx-68)%4)==0) // && posx!=68 && posx!=148)
    {
      pf_bit=pf_bit<<1;
    }

    if ((player0&0xf00)!=0)
    {
      player0_clocks++;
      if ((player0_clocks%(1<<(write_regs[NUSIZ0]&0x03)))==0)
      {
        player0=player0>>1;
      }
    }

    if (tv.getX()==0)
    {
      wsync=0;
      posx=0;
    }
  }

  /** Apply clock to TIA.  Tell TIA to do something interesting and send
      clock pulse to TV */

  public void clock()
  {
    if (posx>=68)
    { calc_pixel(); }
      else
    { posx++; }
    tv.clock();
  }

  public void clock(int n)
  {
    n=n*3;
    while(n>0 || wsync==1)
    {
//System.out.println(posx+"---"+tv.getX()+"---"+wsync);
      clock();
      n--;
    }
  }

  /** Read from TIA */

  public char read_mem(int addr)
  {
    if (addr>0x0d)
    {
      System.out.println("Jatari 65xx memory fault - tried to read address "+addr);
      System.exit(1);
    }
    return read_regs[addr];
  }

  /** Write to TIA */

  public void write_mem(int addr, char value)
  {
    if (addr==WSYNC) wsync=1;
      else
    if (addr==VSYNC && (value&2)==2) tv.vsync();

    write_regs[addr&0x3f]=value;

    if (addr>=PF0 && addr<=PF2)
    {
      calc_playfield();
    }
      else
    if (addr==RESP0)
    {
      if ((write_regs[REFP0]&8)==0)
      { player0=0x800|reverser[write_regs[GRP0]]; }
        else
      { player0=0x800|write_regs[GRP0]; }
      player0_clocks=0;
    }
      else
    if (addr==HMCLR)
    {
      write_regs[HMP0]=0;
      write_regs[HMP1]=0;
      write_regs[HMM0]=0;
      write_regs[HMM1]=0;
      write_regs[HMBL]=0;
    }
  }
}


