#!/usr/bin/env python

import sys

def count_braces(s):
  count=0

  for i in s:
    if i=='{': count=count+1
    elif i=='}': count=count-1

  return count

fp=open("m65xx.java","r")

opcodes=[]
#opcodes.append(range(0,255))
for i in range(0,255): opcodes.append("")
opcode_code=""
add_opcode=-1
braces=0
count=0

while 1:
  line=fp.readline()
  if not line: break

  if line.find("if (opcode==")!=-1 and line.find("opcode&0x10")==-1:
    if add_opcode!=-1:
      print "Uh oh?  new opcode in odd area?"
      print line.strip()
      sys.exit(0)

    a=int(line.split("==")[1].split(")")[0].strip(),16)
    #print "Found "+str(a)
    add_opcode=a
    opcode_code=line
    line=fp.readline()
    count=count+1

  if add_opcode!=-1:
    opcode_code=opcode_code+line
    if line.find("{")!=-1:
      braces=braces+1
    if line.find("}")!=-1:
      braces=braces-1
    if braces==0:
      opcodes[add_opcode]=opcode_code
      add_opcode=-1
      opcode_code=""

fp.close()

#opcodes.sort()

#print len(opcodes)
#print count
braces=0

for opcode in opcodes:
  if opcode!="":
    lines=opcode.split("\n")
    if lines[0].find("//")==-1: print "Couldn't find // in "+lines[0]
    comment=lines[0].split("//")[1]
    num=lines[0].split("==")[1].split(")")[0]
    a=int(num,16)
    print "        case "+num+":     // "+comment
    if opcode.find("branch")!=-1:
      print "          branch=(byte)bus.read_mem(PC+1);"

    lines=lines[2:]
    braces=1
    for line in lines:
      brace_delta=count_braces(line)

      if braces+brace_delta==0: break

      if brace_delta>0:
        print "          "+("  "*(braces-1))+line.strip()
        braces=braces+brace_delta
      else:
        braces=braces+brace_delta
        print "          "+("  "*(braces-1))+line.strip()

    print "          break;"
    print ""

#### warning.. brances need an extra PC++


