import java.lang.*;
import java.io.*;
import java.util.*;

/*

m65xx.java - Copyright 2003-2008 by Michael Kohn

Part of the Jatari project.  This module falls under the GPL license.

1 2 1 2 The Naken Crew

Email: mike@mikekohn.net
  Web: http://www.mikekohn.net/

*/

public class m65xx
{
final int debug=0;
final int count_cycles=1;
final int count_instructions=1;
// public Thread myThread;
int A,X,Y,SP,P;
int PC;
byte N,V,R,B,D,I,C;
int Z;
int total_instructions;
public int cycles;
MemoryBus bus;

  /** Our constructor.  The filename is the name of the ROM file
      to load. */

  public m65xx(String filename)
  {
    A=0;
    X=0;
    Y=0;
    SP=0xff;
    PC=0;
    P=0;

    N=0;
    V=0;
    R=0;
    B=0;
    D=0;
    I=0;
    Z=1;
    C=0;

    bus=new MemoryBus(filename);
  }

  /** Dump flags to console for debugging. */

  public void dump_flags()
  {
  int z;

    if (Z!=0)
    { z=0; }
      else
    { z=1; }
    if (N!=0) N=1;

    System.out.println("SP=$"+Integer.toHexString((int)SP));
    System.out.println("PC=$"+Integer.toHexString((int)PC));
    System.out.print("N="+N+"  V="+V+"  R="+R+"  B="+B+"  ");
    System.out.println("D="+D+"  I="+I+"  Z="+z+"  C="+C);
    System.out.print("A=$"+Integer.toHexString(A)+"  ");
    System.out.print("X=$"+Integer.toHexString(X)+"  ");
    System.out.println("Y=$"+Integer.toHexString(Y));
    System.out.println("total_instructions="+total_instructions);
    System.out.println("clock cycles="+cycles);

    dumpRAM(0x284,0x284);
  }

  /** Throw illegal instruction trap */

  public void illegal_instruction()
  {
    System.out.println("Illegal Instruction Exception PC=$"+Integer.toHexString((int)PC)+" -- $"+Integer.toHexString((int)bus.read_mem(PC)));
    dump_flags();
  }

  /** Dump an area of RAM to the console for debugging. */

  public void dumpRAM(int start, int end)
  {
  int t;

    for (t=start; t<=end; t++)
    {
      System.out.print(Integer.toHexString((int)bus.read_mem(t))+" ");
      if (t%16==0) System.out.println();
    }
  }

  /** Put processor state into P.  I guess this didn't have to be
      some global variable, but what the hell.  Globals are fun! */

  public void load_P()
  {
  int z;

    if (Z!=0)
    { z=0; }
      else
    { z=1; }
    if (N!=0) N=1;

    P=((N<<7)+(V<<6)+(B<<4)+(D<<3)+(I<<2)+(z<<1)+C);
  }

  /** Unload the P register back into the status flags */

  public void unload_P()
  {
    N=(byte)((P>>7)&1);
    V=(byte)((P>>6)&1);
    R=(byte)((P>>5)&1);
    B=(byte)((P>>4)&1);
    D=(byte)((P>>3)&1);
    I=(byte)((P>>2)&1);
    Z=(byte)(((P>>1)&1)^1);
    C=(byte)(P&1);
  }

  /** Main cpu thread.  Can be threaded or called directly. */

  public void run()
  {
  // int low_nibble;
  byte branch,b;
  int M,temp;
  int opcode;
  boolean running=true;

    bus.init();

    // 4k ROMS
    PC=bus.read_mem(0xfffc)|bus.read_mem(0xfffd)<<8;

    // 2k ROMS
    if (PC==0)
    { PC=bus.read_mem(0xf7fc)|bus.read_mem(0xf7fd)<<8; }

    if (count_instructions==1) total_instructions=0;
    // cycles=0;

    while(running==true)
    {
      if (debug==1) System.out.println(Integer.toHexString((int)PC)+" $"+
                                 Integer.toHexString((int)bus.read_mem(PC+0))+" $"+
                                 Integer.toHexString((int)bus.read_mem(PC+1))+" $"+
                                 Integer.toHexString((int)bus.read_mem(PC+2)));


      if (count_instructions==1) total_instructions++;
      // cycles=0;
      // low_nibble=bus.read_mem(PC)&0x0f;
      opcode=bus.read_mem(PC);

// if (total_instructions==1700000) break;
      switch(opcode)
      {
        case 0x00:     //  BRK
          if (debug==1) System.out.println(PC + " BRK");
          if (count_cycles==1) cycles=7;
          running=false;
          break;

        case 0x01:     //  ORA ((Indirect, X))
          if (debug==1) System.out.println(PC + " ORA");
          M=bus.read_mem(++PC)+X;
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8);
          A=A|bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0x05:     //  ORA (Zero Page)
          if (debug==1) System.out.println(PC + " ORA");

          M=bus.read_mem(++PC);
          A=A|bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=3;
          break;

        case 0x06:     //  ASL (Zero Page)
          if (debug==1) System.out.println(PC + " ASL");

          M=bus.read_mem(++PC);
          C=(byte)((bus.read_mem(M)&128)>>7);
          bus.write_mem(M,(char)((bus.read_mem(M)<<1)&255));

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=5;
          break;

        case 0x08:     //  PHP
          if (debug==1) System.out.println(PC + " PHP");

          load_P();
          bus.write_mem(SP--,(char)P);
          if (count_cycles==1) cycles=3;
          break;

        case 0x09:     //  ORA (Immediate)
          if (debug==1) System.out.println(PC + " ORA");

          A=A^bus.read_mem(++PC);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0x0a:     //  ASL (Accumulator)
          if (debug==1) System.out.println(PC + " ASL");

          C=(byte)((A&128)>>7);
          A=((A<<1)&255);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0x0d:     //  ORA (Absolute)
          if (debug==1) System.out.println(PC + " ORA");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          A=A|bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0x0e:     //  ASL (Absolute)
          if (debug==1) System.out.println(PC + " ASL");

          M=bus.read_mem(++PC);
          M=(bus.read_mem(++PC)<<8);
          C=(byte)((bus.read_mem(M)&128)>>7);
          bus.write_mem(M,(char)((bus.read_mem(M)<<1)&255));

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0x10:     //  BPL
          branch=(byte)bus.read_mem(PC+1);
          if (debug==1) System.out.println(PC + " BPL");

          if (N==0)
          {
            PC=PC+branch;
            if (count_cycles==1)
            {
              if ((PC&255)!=((PC-branch)&255))
              { cycles=3; }
              else
              { cycles=2; }
            }
          }
            else
          if (count_cycles==1) cycles=2;

          PC++;
          break;

        case 0x11:     //  ORA ((Indirect), Y)
          if (debug==1) System.out.println(PC + " ORA");
          M=bus.read_mem(++PC);
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8)+Y;
          A=A|bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=5;
          break;

        case 0x15:     //  ORA (Zero Page, X)
          if (debug==1) System.out.println(PC + " ORA");

          M=bus.read_mem(++PC)+X;
          A=A|bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0x16:     //  ASL (Zero Page, X)
          if (debug==1) System.out.println(PC + " ASL");

          M=bus.read_mem(++PC)+X;
          C=(byte)((bus.read_mem(M)&128)>>7);
          bus.write_mem(M,(char)((bus.read_mem(M)<<1)&255));

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0x18:     //  CLC
          if (debug==1) System.out.println(PC + " CLC");
          C=0;
          if (count_cycles==1) cycles=2;
          break;

        case 0x19:     //  ORA (Absolute, Y)
          if (debug==1) System.out.println(PC + " ORA");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+Y;
          A=A|bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0x1d:     //  ORA (Absolute, X)
          if (debug==1) System.out.println(PC + " ORA");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+X;
          A=A|bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0x1e:     //  ASL (Absolute, X)
          if (debug==1) System.out.println(PC + " ASL");

          M=bus.read_mem(++PC);
          M=(bus.read_mem(++PC)<<8)+X;
          C=(byte)((bus.read_mem(M)&128)>>7);
          bus.write_mem(M,(char)((bus.read_mem(M)<<1)&255));

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=7;
          break;

        case 0x20:     //  JSR
          if (debug==1) System.out.println(PC + " JSR");

          bus.write_mem(SP--,(char)(((PC+2)>>8)&(int)255));
          bus.write_mem(SP--,(char)((PC+2)&(int)255));
          PC=(bus.read_mem(PC+2)<<8)+bus.read_mem(PC+1);
          if (count_cycles==1) cycles=6;
          continue;

        case 0x21:     //  AND ((Indirect, X))
          if (debug==1) System.out.println(PC + " AND");
          M=bus.read_mem(++PC)+X;
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8);
          A=A&bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0x24:     //  BIT (Zero Page)
          if (debug==1) System.out.println(PC + " BIT");

          temp=(A&bus.read_mem(++PC));

          Z=temp;
          N=(byte)(temp&128);
          V=(byte)(temp&64);
          if (count_cycles==1) cycles=3;
          break;

        case 0x25:     //  AND (Zero Page)
          if (debug==1) System.out.println(PC + " AND");

          M=bus.read_mem(++PC);
          A=A&bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=3;
          break;

        case 0x26:     //  ROL (Zero Page)
          if (debug==1) System.out.println(PC + " ROL");

          M=++PC;
          temp=(byte)(bus.read_mem(M)&128);
          bus.write_mem(M,(char)((bus.read_mem(M)<<1)+C));

          C=(byte)(temp>>7);
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=5;
          break;

        case 0x28:     //  PLP
          if (debug==1) System.out.println(PC + " PLP");

          P=bus.read_mem(++SP);
          unload_P();
          if (count_cycles==1) cycles=4;
          break;

        case 0x29:     //  AND (Immediate)
          if (debug==1) System.out.println(PC + " AND");

          A=A&bus.read_mem(++PC);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0x2a:     //  ROL (Accumulator)
          if (debug==1) System.out.println(PC + " ROL");

          temp=(byte)(A&128);
          A=(A<<1)+C;

          C=(byte)(temp>>7);
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0x2c:     //  BIT (Absolute)
          if (debug==1) System.out.println(PC + " BIT");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          temp=(A&bus.read_mem(M));

          Z=temp;
          N=(byte)(temp&128);
          V=(byte)(temp&64);
          if (count_cycles==1) cycles=4;
          break;

        case 0x2d:     //  AND (Absolute)
          if (debug==1) System.out.println(PC + " AND");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          A=A&bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0x2e:     //  ROR (Absolute)
          if (debug==1) System.out.println(PC + " ROR");

          M=(++PC);
          M=M+((++PC)<<8);
          temp=(byte)(bus.read_mem(M)&1);
          bus.write_mem(M,(char)((bus.read_mem(M)>>1)+(C<<7)));

          C=(byte)temp;
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0x30:     //  BMI
          branch=(byte)bus.read_mem(PC+1);
          if (debug==1) System.out.println(PC + " BMI");

          if (N!=0)
          {
            PC=PC+branch;
            if (count_cycles==1)
            {
              if ((PC&255)!=((PC-branch)&255))
              { cycles=3; }
              else
              { cycles=2; }
            }
          }
            else
          if (count_cycles==1) cycles=2;

          PC++;
          break;

        case 0x31:     //  AND ((Indirect, Y))
          if (debug==1) System.out.println(PC + " AND");
          M=bus.read_mem(++PC);
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8)+Y;
          A=A&bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=6; }
            else
            { cycles=5; }
          }
          break;

        case 0x35:     //  AND (Zero Page, X)
          if (debug==1) System.out.println(PC + " AND");

          M=bus.read_mem(++PC)+X;
          A=A&bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0x36:     //  ROR (Zero Page, X)
          if (debug==1) System.out.println(PC + " ROR");

          M=(++PC)+X;
          temp=(byte)(bus.read_mem(M)&1);
          bus.write_mem(M,(char)((bus.read_mem(M)>>1)+(C<<7)));

          C=(byte)temp;
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0x38:     //  SEC
          if (debug==1) System.out.println(PC + " SEC");
          C=1;
          if (count_cycles==1) cycles=2;
          break;

        case 0x39:     //  AND (Absolute, Y)
          if (debug==1) System.out.println(PC + " AND");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+Y;
          A=A&bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=(M-Y))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0x3d:     //  AND (Absolute, X)
          if (debug==1) System.out.println(PC + " AND");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+X;
          A=A&bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0x3e:     //  ROR (Absolute, X)
          if (debug==1) System.out.println(PC + " ROR");

          M=(++PC);
          M=M+((++PC)<<8)+X;
          temp=(byte)(bus.read_mem(M)&1);
          bus.write_mem(M,(char)((bus.read_mem(M)>>1)+(C<<7)));

          C=(byte)temp;
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=7;
          break;

        case 0x40:     //  RTI
          if (debug==1) System.out.println(PC + " RTI");

          P=bus.read_mem(++SP);
          unload_P();
          PC=bus.read_mem(++SP);
          PC=PC+((bus.read_mem(++SP))<<8);
          if (count_cycles==1) cycles=6;
          break;

        case 0x41:     //  EOR ((Indirect, X))
          if (debug==1) System.out.println(PC + " EOR");
          M=bus.read_mem(++PC)+X;
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8);
          A=A^bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0x45:     //  EOR (Zero Page)
          if (debug==1) System.out.println(PC + " EOR");

          M=bus.read_mem(++PC);
          A=A^bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=3;
          break;

        case 0x46:     //  LSR (Zero Page)
          if (debug==1) System.out.println(PC + " LSR");

          M=bus.read_mem(++PC);
          C=(byte)(bus.read_mem(M)&1);
          bus.write_mem(M,(char)(bus.read_mem(M)>>1));

          Z=bus.read_mem(M);
          N=0;
          if (count_cycles==1) cycles=5;
          break;

        case 0x48:     //  PHA
          if (debug==1) System.out.println(PC + " PHA");

          bus.write_mem(SP--,(char)A);
          if (count_cycles==1) cycles=3;
          break;

        case 0x49:     //  EOR (Immediate)
          if (debug==1) System.out.println(PC + " EOR");

          A=A^bus.read_mem(++PC);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0x4a:     //  LSR (Accumulator)
          if (debug==1) System.out.println(PC + " LSR");

          C=(byte)(A&1);
          A=((A>>1)&255);

          Z=A;
          N=0;
          if (count_cycles==1) cycles=2;
          break;

        case 0x4c:     //  JMP (Absolute)
          if (debug==1) System.out.println(PC + " JMP");
          PC=bus.read_mem(PC+1)+(bus.read_mem(PC+2)<<8);
          if (count_cycles==1) cycles=3;
          continue;

        case 0x4d:     //  EOR (Absolute)
          if (debug==1) System.out.println(PC + " EOR");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          A=A^bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0x4e:     //  LSR (Absolute)
          if (debug==1) System.out.println(PC + " LSR");

          M=bus.read_mem(++PC);
          M=(bus.read_mem(++PC)<<8);
          C=(byte)(bus.read_mem(M)&1);
          bus.write_mem(M,(char)(bus.read_mem(M)>>1));

          Z=bus.read_mem(M);
          N=0;
          if (count_cycles==1) cycles=6;
          break;

        case 0x50:     //  BVC
          branch=(byte)bus.read_mem(PC+1);
          if (debug==1) System.out.println(PC + " BVC");

          if (V==0)
          {
            PC=PC+branch;
            if (count_cycles==1)
            {
              if ((PC&255)!=((PC-branch)&255))
              { cycles=3; }
              else
              { cycles=2; }
            }
          }
            else
          if (count_cycles==1) cycles=2;

          PC++;
          break;

        case 0x51:     //  EOR ((Indirect, Y))
          if (debug==1) System.out.println(PC + " EOR");
          M=bus.read_mem(++PC);
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8)+Y;
          A=A^bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=6; }
            else
            { cycles=5; }
          }
          break;

        case 0x55:     //  EOR (Zero Page, X)
          if (debug==1) System.out.println(PC + " EOR");

          M=bus.read_mem(++PC)+X;
          A=A^bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0x56:     //  LSR (Zero Page, X)
          if (debug==1) System.out.println(PC + " LSR");

          M=bus.read_mem(++PC)+X;
          C=(byte)(bus.read_mem(M)&1);
          bus.write_mem(M,(char)(bus.read_mem(M)>>1));

          Z=bus.read_mem(M);
          N=0;
          if (count_cycles==1) cycles=6;
          break;

        case 0x58:     //  CLI
          if (debug==1) System.out.println(PC + " CLI");
          I=0;
          if (count_cycles==1) cycles=2;
          break;

        case 0x59:     //  EOR (Absolute, Y)
          if (debug==1) System.out.println(PC + " EOR");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+Y;
          A=A^bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0x5d:     //  EOR (Absolute, X)
          if (debug==1) System.out.println(PC + " EOR");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+X;
          A=A^bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0x5e:     //  LSR (Absolute, X)
          if (debug==1) System.out.println(PC + " LSR");

          M=bus.read_mem(++PC);
          M=(bus.read_mem(++PC)<<8)+X;
          C=(byte)(bus.read_mem(M)&1);
          bus.write_mem(M,(char)(bus.read_mem(M)>>1));

          Z=bus.read_mem(M);
          N=0;
          if (count_cycles==1) cycles=7;
          break;

        case 0x60:     //  RTS
          if (debug==1) System.out.println(PC + " RTS");

          PC=bus.read_mem(++SP);
          PC=PC+((bus.read_mem(++SP))<<8);
          if (count_cycles==1) cycles=6;
          break;

        case 0x61:     //  ADC ((Indirect, X))
          if (debug==1) System.out.println(PC + " ADC");
          M=bus.read_mem(++PC)+X;
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8);
          A=A+bus.read_mem(M)+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=6;
          break;

        case 0x65:     //  ADC (ZeroPage)
          if (debug==1) System.out.println(PC + " ADC");
          M=bus.read_mem(++PC);
          A=A+bus.read_mem(M)+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=3;
          break;

        case 0x66:     //  ROR (Zero Page)
          if (debug==1) System.out.println(PC + " ROR");

          M=++PC;
          temp=(byte)(bus.read_mem(M)&1);
          bus.write_mem(M,(char)((bus.read_mem(M)>>1)+(C<<7)));

          C=(byte)temp;
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=5;
          break;

        case 0x68:     //  PLA
          if (debug==1) System.out.println(PC + " PLA");

          A=bus.read_mem(++SP);
          if (count_cycles==1) cycles=4;
          break;

        case 0x69:     //  AND (Immediate)
          if (debug==1) System.out.println(PC + " AND");
          A=A&bus.read_mem(++PC);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0x6a:     //  ROR (Accumulator)
          if (debug==1) System.out.println(PC + " ROR");

          temp=(byte)(A&1);
          A=(A>>1)+(C<<7);

          C=(byte)temp;
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0x6c:     //  JMP (Indirect)
          if (debug==1) System.out.println(PC + " JMP");
          M=bus.read_mem(PC+1)+(bus.read_mem(PC+2)<<8);
          PC=bus.read_mem(M)+(bus.read_mem(M+1)<<8);
          if (count_cycles==1) cycles=5;
          continue;

        case 0x6d:     //  ADC (Absolute)
          if (debug==1) System.out.println(PC + " ADC");
          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          A=A+bus.read_mem(M)+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=4;
          break;

        case 0x6e:     //  ROL (Absolute)
          if (debug==1) System.out.println(PC + " ROL");

          M=(++PC);
          M=M+((++PC)<<8);
          temp=(byte)(bus.read_mem(M)&128);
          bus.write_mem(M,(char)((bus.read_mem(M)<<1)+C));

          C=(byte)(temp>>7);
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0x70:     //  BVS
          branch=(byte)bus.read_mem(PC+1);
          if (debug==1) System.out.println(PC + " BVS");

          if (V!=0)
          {
            PC=PC+branch;
            if (count_cycles==1)
            {
              if ((PC&255)!=((PC-branch)&255))
              { cycles=3; }
              else
              { cycles=2; }
            }
          }
            else
          if (count_cycles==1) cycles=2;

          PC++;
          break;

        case 0x71:     //  ADC ((Indirect, Y))
          if (debug==1) System.out.println(PC + " ADC");
          M=bus.read_mem(++PC);
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8)+Y;
          A=A+bus.read_mem(M)+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=6; }
            else
            { cycles=5; }
          }
          break;

        case 0x75:     //  ADC (ZeroPage, X)
          if (debug==1) System.out.println(PC + " ADC");
          M=bus.read_mem(++PC)+X;
          A=A+bus.read_mem(M)+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=4;
          break;

        case 0x76:     //  ROL (Zero Page, X)
          if (debug==1) System.out.println(PC + " ROL");

          M=(++PC)+X;
          temp=(byte)(bus.read_mem(M)&128);
          bus.write_mem(M,(char)((bus.read_mem(M)<<1)+C));

          C=(byte)(temp>>7);
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0x78:     //  SEI
          if (debug==1) System.out.println(PC + " SEI");
          I=1;
          if (count_cycles==1) cycles=2;
          break;

        case 0x79:     //  ADC (Absolute, Y)
          if (debug==1) System.out.println(PC + " ADC");
          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+Y;
          A=A+bus.read_mem(M)+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0x7d:     //  ADC (Absolute, X)
          if (debug==1) System.out.println(PC + " ADC");
          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+X;
          A=A+bus.read_mem(M)+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0x7e:     //  ROL (Absolute, X)
          if (debug==1) System.out.println(PC + " ROL");

          M=(++PC);
          M=M+((++PC)<<8)+X;
          temp=(byte)(bus.read_mem(M)&128);
          bus.write_mem(M,(char)((bus.read_mem(M)<<1)+C));

          C=(byte)(temp>>7);
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=7;
          break;

        case 0x81:     //  STA ((Indirect, X))
          if (debug==1) System.out.println(PC + " STA");

          M=bus.read_mem(++PC)+X;
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8);
          bus.write_mem(M,(char)A);
          if (count_cycles==1) cycles=6;
          break;

        case 0x84:     //  STY (Zero Page)
          if (debug==1) System.out.println(PC + " STY");

          M=bus.read_mem(++PC);
          bus.write_mem(M,(char)Y);
          if (count_cycles==1) cycles=3;
          break;

        case 0x85:     //  STA (Zero Page)
          if (debug==1) System.out.println(PC + " STA");

          M=bus.read_mem(++PC);
          bus.write_mem(M,(char)A);
          if (count_cycles==1) cycles=3;
          break;

        case 0x86:     //  STX (Zero Page)
          if (debug==1) System.out.println(PC + " STX");

          M=bus.read_mem(++PC);
          bus.write_mem(M,(char)X);
          if (count_cycles==1) cycles=3;
          break;

        case 0x88:     //  DEY (Implied)
          if (debug==1) System.out.println(PC + " DEY");
          Y--;
          if (Y<0) Y=255;

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0x8a:     //  TXA
          if (debug==1) System.out.println(PC + " TXA");

          A=X;

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0x8c:     //  STY (Absolute)
          if (debug==1) System.out.println(PC + " STY");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          bus.write_mem(M,(char)Y);
          if (count_cycles==1) cycles=4;
          break;

        case 0x8d:     //  STA (Absolute)
          if (debug==1) System.out.println(PC + " STA");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          bus.write_mem(M,(char)A);
          if (count_cycles==1) cycles=4;
          break;

        case 0x8e:     //  STX (Absolute)
          if (debug==1) System.out.println(PC + " STX");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          bus.write_mem(M,(char)X);
          if (count_cycles==1) cycles=4;
          break;

        case 0x90:     //  BCC
          branch=(byte)bus.read_mem(PC+1);
          if (debug==1) System.out.println(PC + " BCC");

          if (C==0)
          {
            PC=PC+branch;
            if (count_cycles==1)
            {
              if ((PC&255)!=((PC-branch)&255))
              { cycles=4; }
              else
              { cycles=3; }
            }
          }
            else
          if (count_cycles==1) cycles=2;
          PC++;

          break;

        case 0x91:     //  STA ((Indirect), Y)
          if (debug==1) System.out.println(PC + " STA");

          M=bus.read_mem(++PC);
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8)+Y;
          bus.write_mem(M,(char)A);
          if (count_cycles==1) cycles=6;
          break;

        case 0x94:     //  STY (Zero Page, X)
          if (debug==1) System.out.println(PC + " STY");

          M=bus.read_mem(++PC)+X;
          bus.write_mem(M,(char)Y);
          if (count_cycles==1) cycles=4;
          break;

        case 0x95:     //  STA (Zero Page, X)
          if (debug==1) System.out.println(PC + " STA");

          M=bus.read_mem(++PC)+X;
          bus.write_mem(M,(char)A);
          if (count_cycles==1) cycles=4;
          break;

        case 0x96:     //  STX (Zero Page, Y)
          if (debug==1) System.out.println(PC + " STX");

          M=bus.read_mem(++PC)+Y;
          bus.write_mem(M,(char)X);
          if (count_cycles==1) cycles=3;
          break;

        case 0x98:     //  TYA
          if (debug==1) System.out.println(PC + " TYA");

          A=Y;

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0x99:     //  STA (Absolute, Y)
          if (debug==1) System.out.println(PC + " STA");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+Y;
          bus.write_mem(M,(char)A);
          if (count_cycles==1) cycles=5;
          break;

        case 0x9a:     //  TXS
          if (debug==1) System.out.println(PC + " TXS");

          SP=X;
          if (count_cycles==1) cycles=2;
          break;

        case 0x9d:     //  STA (Absolute, X)
          if (debug==1) System.out.println(PC + " STA");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+X;
          bus.write_mem(M,(char)A);
          if (count_cycles==1) cycles=5;
          break;

        case 0xa0:     //  LDY (Immediate)
          if (debug==1) System.out.println(PC + " LDY");

          Y=bus.read_mem(++PC);

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xa1:     //  LDA ((Indirect, X))
          if (debug==1) System.out.println(PC + " LDA");

          M=bus.read_mem(++PC)+X;
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8);
          A=bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0xa2:     //  LDX (Immediate)
          if (debug==1) System.out.println(PC + " LDX");

          X=bus.read_mem(++PC);

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xa4:     //  LDY (Zero Page)
          if (debug==1) System.out.println(PC + " LDY");

          M=bus.read_mem(++PC);
          Y=bus.read_mem(M);

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=3;
          break;

        case 0xa5:     //  LDA (Zero Page)
          if (debug==1) System.out.println(PC + " LDA");

          M=bus.read_mem(++PC);
          A=bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=3;
          break;

        case 0xa6:     //  LDX (Zero Page)
          if (debug==1) System.out.println(PC + " LDX");

          M=bus.read_mem(++PC);
          X=bus.read_mem(M);

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=3;
          break;

        case 0xa8:     //  TAY
          if (debug==1) System.out.println(PC + " TAY");

          Y=A;

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xa9:     //  LDA (Immediate)
          if (debug==1) System.out.println(PC + " LDA");

          A=bus.read_mem(++PC);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xaa:     //  TAX
          if (debug==1) System.out.println(PC + " TAX");

          X=A;

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xac:     //  LDY (Absolute)
          if (debug==1) System.out.println(PC + " LDY");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          Y=bus.read_mem(M);

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0xad:     //  LDA (Absolute)
          if (debug==1) System.out.println(PC + " LDA");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          A=bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0xae:     //  LDX (Absolute)
          if (debug==1) System.out.println(PC + " LDX");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          X=bus.read_mem(M);

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0xb0:     //  BCS
          branch=(byte)bus.read_mem(PC+1);
          if (debug==1) System.out.println(PC + " BCS");

          if (C!=0)
          {
            PC=PC+branch;
            if (count_cycles==1)
            {
              if ((PC&255)!=((PC-branch)&255))
              { cycles=3; }
              else
              { cycles=2; }
            }
          }
            else
          if (count_cycles==1) cycles=2;
          PC++;

          break;

        case 0xb1:     //  LDA ((Indirect), Y)
          if (debug==1) System.out.println(PC + " LDA");

          M=bus.read_mem(++PC);
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8)+Y;
          A=bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=6; }
            else
            { cycles=5; }
          }
          break;

        case 0xb4:     //  LDY (Zero Page, X)
          if (debug==1) System.out.println(PC + " LDY");

          M=bus.read_mem(++PC)+X;
          Y=bus.read_mem(M);

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0xb5:     //  LDA (Zero Page, X)
          if (debug==1) System.out.println(PC + " LDA");

          M=bus.read_mem(++PC)+X;
          A=bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0xb6:     //  LDX (Zero Page, Y)
          if (debug==1) System.out.println(PC + " LDX");

          M=bus.read_mem(++PC)+Y;
          X=bus.read_mem(M);

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0xb8:     //  CLV
          if (debug==1) System.out.println(PC + " CLV");
          V=0;
          if (count_cycles==1) cycles=2;
          break;

        case 0xb9:     //  LDA (Absolute, Y)
          if (debug==1) System.out.println(PC + " LDA");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+Y;
          A=bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0xba:     //  TSX
          if (debug==1) System.out.println(PC + " TSX");

          X=SP;

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xbc:     //  LDY (Absolute, X)
          if (debug==1) System.out.println(PC + " LDY");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+X;
          Y=bus.read_mem(M);

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0xbd:     //  LDA (Absolute, X)
          if (debug==1) System.out.println(PC + " LDA");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+X;
          A=bus.read_mem(M);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0xbe:     //  LDX (Absolute, Y)
          if (debug==1) System.out.println(PC + " LDX");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+Y;
          X=bus.read_mem(M);

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0xc0:     //  CPY (Immediate)
          if (debug==1) System.out.println(PC + " CPY");

          temp=Y-bus.read_mem(++PC);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xc1:     //  CMP ((Indirect, X))
          if (debug==1) System.out.println(PC + " CMP");

          M=bus.read_mem(++PC)+X;
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8);
          temp=A-bus.read_mem(M);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0xc4:     //  CPY (Zero Page)
          if (debug==1) System.out.println(PC + " CPY");

          M=bus.read_mem(++PC);
          temp=Y-bus.read_mem(M);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=3;
          break;

        case 0xc5:     //  CMP (Zero Page)
          if (debug==1) System.out.println(PC + " CMP");

          M=bus.read_mem(++PC);
          temp=A-bus.read_mem(M);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=3;
          break;

        case 0xc6:     //  DEC (Zero Page)
          if (debug==1) System.out.println(PC + " DEC");

          M=bus.read_mem(++PC);
          if (bus.read_mem(M)==0)
          { bus.write_mem(M,(char)255); }
          else
          { bus.dec_mem(M); }

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=5;
          break;

        case 0xc8:     //  INY (Implied)
          if (debug==1) System.out.println(PC + " INY");
          Y++;
          if (Y>255) Y=0;

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xc9:     //  CMP (Immediate)
          if (debug==1) System.out.println(PC + " CMP");

          temp=A-bus.read_mem(++PC);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xca:     //  DEX
          if (debug==1) System.out.println(PC + " DEX");
          X--;
          if (X<0) X=255;

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xcc:     //  CPY (Absolute)
          if (debug==1) System.out.println(PC + " CPY");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          temp=Y-bus.read_mem(M);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0xcd:     //  CMP (Absolute)
          if (debug==1) System.out.println(PC + " CMP");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          temp=A-bus.read_mem(M);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0xce:     //  DEC (Absolute)
          if (debug==1) System.out.println(PC + " DEC");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          if (bus.read_mem(M)==0)
          { bus.write_mem(M,(char)255); }
          else
          { bus.dec_mem(M); }

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0xd0:     //  BNE
          branch=(byte)bus.read_mem(PC+1);
          if (debug==1) System.out.println(PC + " BNE");

          if (Z!=0)
          {
            PC=PC+branch;
            if (count_cycles==1)
            {
              if ((PC&255)!=((PC-branch)&255))
              { cycles=3; }
              else
              { cycles=2; }
            }
          }
            else
          if (count_cycles==1) cycles=2;
          PC++;

          break;

        case 0xd1:     //  CMP ((Indirect), Y)
          if (debug==1) System.out.println(PC + " CMP");

          M=bus.read_mem(++PC);
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8)+Y;
          temp=A-bus.read_mem(M);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=6; }
            else
            { cycles=5; }
          }
          break;

        case 0xd5:     //  CMP (Zero Page, X)
          if (debug==1) System.out.println(PC + " CMP");

          M=bus.read_mem(++PC)+X;
          temp=A-bus.read_mem(M);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0xd6:     //  DEC (Zero Page, X)
          if (debug==1) System.out.println(PC + " DEC");

          M=bus.read_mem(++PC)+X;
          if (bus.read_mem(M)==0)
          { bus.write_mem(M,(char)255); }
          else
          { bus.dec_mem(M); }

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0xd8:     //  CLD
          if (debug==1) System.out.println(PC + " CLD");
          D=0;
          if (count_cycles==1) cycles=2;
          break;

        case 0xd9:     //  CMP (Absolute, Y)
          if (debug==1) System.out.println(PC + " CMP");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+Y;
          temp=A-bus.read_mem(M);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0xdd:     //  CMP (Absolute, X)
          if (debug==1) System.out.println(PC + " CMP");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+X;
          temp=A-bus.read_mem(M);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0xde:     //  DEC (Absolute, X)
          if (debug==1) System.out.println(PC + " DEC");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+X;
          if (bus.read_mem(M)==0)
          { bus.write_mem(M,(char)255); }
          else
          { bus.dec_mem(M); }

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=7;
          break;

        case 0xe0:     //  CPX (Immediate)
          if (debug==1) System.out.println(PC + " CPX");

          temp=X-bus.read_mem(++PC);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xe1:     //  SBC ((Indirect, X))
          if (debug==1) System.out.println(PC + " SBC");

          M=bus.read_mem(++PC)+X;
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8);
          A=A-bus.read_mem(M)-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=6;
          break;

        case 0xe4:     //  CPX (Zero Page)
          if (debug==1) System.out.println(PC + " CPX");

          M=bus.read_mem(++PC);
          temp=X-bus.read_mem(M);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=3;
          break;

        case 0xe5:     //  SBC (Zero Page)
          if (debug==1) System.out.println(PC + " SBC");
          M=bus.read_mem(++PC);
          A=A-bus.read_mem(M)-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=3;
          break;

        case 0xe6:     //  INC (Zero Page)
          if (debug==1) System.out.println(PC + " INC");

          M=bus.read_mem(++PC);
          bus.inc_mem(M);
          if (bus.read_mem(M)>255)
          { bus.write_mem(M,(char)0); }

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=5;
          break;

        case 0xe8:     //  INX (Implied)
          if (debug==1) System.out.println(PC + " INX");
          X++;
          if (X>255) X=0;

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=2;
          break;

        case 0xe9:     //  SBC (Immediate)
          if (debug==1) System.out.println(PC + " SBC");
          A=A-bus.read_mem(++PC)-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=2;
          break;

        case 0xea:     //  NOP
          if (debug==1) System.out.println(PC + " NOP");
          if (count_cycles==1) cycles=2;
          break;

        case 0xec:     //  CPX (Absolute)
          if (debug==1) System.out.println(PC + " CPX");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          temp=X-bus.read_mem(M);
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
          else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=4;
          break;

        case 0xed:     //  SBC (Absolute)
          if (debug==1) System.out.println(PC + " SBC");
          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          A=A-bus.read_mem(M)-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=4;
          break;

        case 0xee:     //  INC (Absolute)
          if (debug==1) System.out.println(PC + " INC");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8);
          bus.inc_mem(M);
          if (bus.read_mem(M)>255)
          { bus.write_mem(M,(char)0); }

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0xf0:     //  BEQ
          branch=(byte)bus.read_mem(PC+1);
          if (debug==1) System.out.println(PC + " BEQ");

          if (Z==0)
          {
            PC=PC+branch;
            if (count_cycles==1)
            {
              if ((PC&255)!=((PC-branch)&255))
              { cycles=3; }
              else
              { cycles=2; }
            }
          }
            else
          if (count_cycles==1) cycles=2;

          PC++;
          break;

        case 0xf1:     //  SBC ((Indirect), Y)
          if (debug==1) System.out.println(PC + " SBC");

          M=bus.read_mem(++PC);
          M=bus.read_mem(M)+(bus.read_mem(M+1)<<8)+Y;
          A=A-bus.read_mem(M)-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=6; }
            else
            { cycles=5; }
          }
          break;

        case 0xf5:     //  SBC (Zero Page, X)
          if (debug==1) System.out.println(PC + " SBC");
          M=bus.read_mem(++PC)+X;
          A=A-bus.read_mem(M)-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=4;
          break;

        case 0xf6:     //  INC (Zero Page, X)
          if (debug==1) System.out.println(PC + " INC");

          M=bus.read_mem(++PC)+X;
          bus.inc_mem(M);
          if (bus.read_mem(M)>255)
          { bus.write_mem(M,(char)0); }

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=6;
          break;

        case 0xf8:     //  SED
          if (debug==1) System.out.println(PC + " SED");
          D=1;
          if (count_cycles==1) cycles=2;
          break;

        case 0xf9:     //  SBC (Absolute, Y)
          if (debug==1) System.out.println(PC + " SBC");
          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+Y;
          A=A-bus.read_mem(M)-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0xfd:     //  SBC (Absolute, X)
          if (debug==1) System.out.println(PC + " SBC");
          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+X;
          A=A-bus.read_mem(M)-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
          else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=5; }
            else
            { cycles=4; }
          }
          break;

        case 0xfe:     //  INC (Absolute, X)
          if (debug==1) System.out.println(PC + " INC");

          M=bus.read_mem(++PC);
          M=M+(bus.read_mem(++PC)<<8)+X;
          bus.inc_mem(M);
          if (bus.read_mem(M)>255)
          { bus.write_mem(M,(char)0); }

          Z=bus.read_mem(M);
          N=(byte)(bus.read_mem(M)&128);
          if (count_cycles==1) cycles=7;
          break;

        default:
          System.out.println("Illegal Insruction "+opcode);
          cycles=0;
      }

      PC++;
      if (count_cycles==1) cycles++;

      if (debug==1) dump_flags();

      bus.clock(cycles);
    }

    dump_flags();

    if (debug==1)
    {
      System.out.println("Execution has ended");
    }
  }
}


