import java.lang.*;
import java.io.*;
import java.util.*;

/*

m65xx.java - Copyright 2003-2008 by Michael Kohn 

Part of the Jatari project.  This module falls under the GPL license.

1 2 1 2 The Naken Crew

Email: mike@mikekohn.net
  Web: http://www.mikekohn.net/

*/

public class m65xx implements Runnable
{
final int debug=1;
final int atari=1;
final int count_cycles=1;
public Thread myThread;
public char[] ram=new char[65536];
int A,X,Y,SP,P;
int PC;
byte N,V,R,B,D,I,C;
int Z;
int total_instructions;
public int cycles;
int pia_interval,pia_counts=0;   // Atari only

  public m65xx()
  {
  int t;

    A=0;
    X=0;
    Y=0;
    SP=0xff;
    PC=0;
    P=0;

    N=0;
    V=0;
    R=0;
    B=0;
    D=0;
    I=0;
    Z=1;
    C=0;

    for (t=0; t<65535; t++) ram[t]=0;
  }

  public void dump_flags()
  {
  int z;

    if (Z!=0)
    { z=0; }
      else
    { z=1; }
    if (N!=0) N=1;

    System.out.println("SP=$"+Integer.toHexString((int)SP));
    System.out.println("PC=$"+Integer.toHexString((int)PC));
    System.out.print("N="+N+"  V="+V+"  R="+R+"  B="+B+"  ");
    System.out.println("D="+D+"  I="+I+"  Z="+z+"  C="+C);
    System.out.print("A=$"+Integer.toHexString(A)+"  ");
    System.out.print("X=$"+Integer.toHexString(X)+"  ");
    System.out.println("Y=$"+Integer.toHexString(Y));
    System.out.println("total_instructions="+total_instructions);
    System.out.println("clock cycles="+cycles);

    dumpRAM(0x284,0x284);
  }

  public void illegal_instruction()
  {
    System.out.println("Illegal Instruction Exception PC=$"+Integer.toHexString((int)PC)+" -- $"+Integer.toHexString((int)ram[PC]));
    dump_flags();
  }

  public int loadROM(String filename, int address)
  {
  File myFile;
  FileInputStream myInputStream;
  int memptr,ch;

    memptr=address;

    try
    {
      myFile=new File(filename);
      myInputStream=new FileInputStream(myFile);

      while(true)
      {
        if (memptr==0xffff) break;
        ch=myInputStream.read();
        if (ch==-1) break;
        ram[memptr]=(char)ch;
        memptr++;
      }

      myInputStream.close();
    }
    catch (Exception e)
    {
      System.out.println("Error: "+e.toString());
      return 1;
    }

    myThread=new Thread(this);
    myThread.start();

    return 0;
  }

  public void dumpRAM(int start, int end)
  {
  int t;

    for (t=start; t<=end; t++)
    {
      System.out.print(Integer.toHexString((int)ram[t])+" ");
      if (t%16==0) System.out.println();
    }
  }

  public void load_P()
  {
  int z;

    if (Z!=0)
    { z=0; }
      else
    { z=1; }
    if (N!=0) N=1;

    P=((N<<7)+(V<<6)+(B<<4)+(D<<3)+(I<<2)+(z<<1)+C);
  }

  public void unload_P()
  {
    N=(byte)((P>>7)&1);
    V=(byte)((P>>6)&1);
    R=(byte)((P>>5)&1);
    B=(byte)((P>>4)&1);
    D=(byte)((P>>3)&1);
    I=(byte)((P>>2)&1);
    Z=(byte)(((P>>1)&1)^1);
    C=(byte)(P&1);
  }

  public void run()
  {
  int low_nibble;
  byte branch,b;
  int M,temp;
  int opcode;
  int old_cycles=0;  // Atari only

    PC=0xf000;
    total_instructions=0;
    cycles=0;

/* Atari Specific */

    if (atari==1)
    {
        ram[2]=0x02;
        ram[0x294]=0x100;
        ram[0x295]=0x100;
        ram[0x296]=0x100;
        ram[0x297]=0x100;
        ram[0x284]=0x00;
        pia_interval=1;
        pia_counts=0;
    }

/* End Atari Specific */

    while(true)
    {
if (debug==1) System.out.println(Integer.toHexString((int)PC)+" $"+
                                 Integer.toHexString((int)ram[PC+0])+" $"+
                                 Integer.toHexString((int)ram[PC+1])+" $"+
                                 Integer.toHexString((int)ram[PC+2]));

/* Atari Specific */

      if (atari==1)
      {
        if (ram[0x294]!=100)
        {
          ram[284]=ram[0x294];
          pia_interval=1;
          ram[0x294]=100;
          pia_counts=ram[284];
        }
          else
        if (ram[0x295]!=100)
        {
          ram[284]=ram[0x295];
          pia_interval=8;
          ram[0x295]=100;
          pia_counts=ram[284]*8;
        }
          else
        if (ram[0x296]!=100)
        {
          ram[284]=ram[0x296];
          pia_interval=64;
          ram[0x296]=100;
          pia_counts=ram[284]*64;
        }
          else
        if (ram[0x297]!=100)
        {
          ram[284]=ram[0x297];
          pia_interval=1024;
          ram[0x297]=100;
          pia_counts=ram[284]*1024;
        }
          else
        {
          if (pia_counts>0)
          {
            pia_counts=pia_counts-(cycles-old_cycles);
            if ((pia_counts/pia_interval)>0)
            { ram[0x284]=(char)(pia_counts/pia_interval); }
              else
            { ram[0x284]=(char)(255+(int)(pia_counts/pia_interval)); }
          }
            else
          {
            if (ram[0x284]==0)
            { ram[0x284]=0xff; }
              else
            { ram[0x284]--; }
          }
        }

        if (ram[2]!=0x100)
        {
          if (debug==1) System.out.println("WSYNC="+(int)ram[2]);

          M=0;
          try { myThread.sleep(10000); }
          catch (Exception e) { M=1; }

          // if (myThread.interrupted()==false)
          if (M==0)
          {
            System.out.println("Lost Video Signal");
            break;
          }

          ram[2]=0x100;
          continue;
        }

        old_cycles=cycles;
      }

/* End Atari Specific */

      total_instructions++;
      low_nibble=ram[PC]&0x0f;
      opcode=ram[PC];

// if (total_instructions==1700000) break;
// if (total_instructions==900) break;

      if (low_nibble==0x09)
      {
        if (opcode==0xa9) // LDA (Immediate)
        {
          if (debug==1) System.out.println(PC + " LDA");

          A=ram[++PC];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xb9) // LDA (Absolute, Y)
        {
          if (debug==1) System.out.println(PC + " LDA");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+Y;
          A=ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x99) // STA (Absolute, Y)
        {
          if (debug==1) System.out.println(PC + " STA");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+Y;
          ram[M]=(char)A;
          if (count_cycles==1) cycles=cycles+5;
        }
          else
        if (opcode==0xc9)  // CMP (Immediate)
        {
          if (debug==1) System.out.println(PC + " CMP");

          temp=A-ram[++PC];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xd9)  // CMP (Absolute, Y)
        {
          if (debug==1) System.out.println(PC + " CMP");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+Y;
          temp=A-ram[M];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x29) // AND (Immediate)
        {
          if (debug==1) System.out.println(PC + " AND");

          A=A&ram[++PC];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x49) // EOR (Immediate)
        {
          if (debug==1) System.out.println(PC + " EOR");

          A=A^ram[++PC];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x09) // ORA (Immediate)
        {
          if (debug==1) System.out.println(PC + " ORA");

          A=A|ram[++PC];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x69) // ADC (Immediate)
        {
          if (debug==1) System.out.println(PC + " ADC");
          A=A+ram[++PC]+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xf9) // SBC (Absolute, Y)
        {
          if (debug==1) System.out.println(PC + " SBC");
          M=ram[++PC];
          M=M+(ram[++PC]<<8)+Y;
          A=A-ram[M]-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x79) // ADC (Absolute, Y)
        {
          if (debug==1) System.out.println(PC + " ADC");
          M=ram[++PC];
          M=M+(ram[++PC]<<8)+Y;
          A=A+ram[M]+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          } 
        }
          else
        if (opcode==0x39) // AND (Absolute, Y)
        {
          if (debug==1) System.out.println(PC + " AND");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+Y;
          A=A&ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=(M-Y))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x59) // EOR (Absolute, Y)
        {
          if (debug==1) System.out.println(PC + " EOR");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+Y;
          A=A^ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x19) // ORA (Absolute, Y)
        {
          if (debug==1) System.out.println(PC + " ORA");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+Y;
          A=A|ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x69) // AND (Immediate)
        {
          if (debug==1) System.out.println(PC + " AND");
          A=A&ram[++PC];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x09) // ORA (Immediate)
        {
          if (debug==1) System.out.println(PC + " ORA");

          A=A^ram[++PC];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xe9) // SBC (Immediate)
        {
          if (debug==1) System.out.println(PC + " SBC");
          A=A-ram[++PC]-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        {
          illegal_instruction();
          break;
        }
      }
        else
      if (low_nibble==0x02)
      {
        if (opcode==0xa2) // LDX (Immediate)
        {
          if (debug==1) System.out.println(PC + " LDX");

          X=ram[++PC];

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        {
          illegal_instruction();
          break;
        }

      }
        else
      if (low_nibble==0x04)
      {
        if (opcode==0xa4) // LDY (Zero Page)
        {
          if (debug==1) System.out.println(PC + " LDY");

          M=ram[++PC];
          Y=ram[M];

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0xb4) // LDY (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " LDY");

          M=ram[++PC]+X;
          Y=ram[M];

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x84) // STY (Zero Page)
        {
          if (debug==1) System.out.println(PC + " STY");

          M=ram[++PC];
          ram[M]=(char)Y;
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0x94) // STY (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " STY");

          M=ram[++PC]+X;
          ram[M]=(char)Y;
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0xe4)  // CPX (Zero Page)
        {
          if (debug==1) System.out.println(PC + " CPX");

          M=ram[++PC];
          temp=X-ram[M];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0xc4)  // CPY (Zero Page)
        {
          if (debug==1) System.out.println(PC + " CPY");

          M=ram[++PC];
          temp=Y-ram[M];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0x24) // BIT (Zero Page)
        {
          if (debug==1) System.out.println(PC + " BIT");

          temp=(A&ram[++PC]);

          Z=temp;
          N=(byte)(temp&128);
          V=(byte)(temp&64);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        {
          illegal_instruction();
          break;
        }
      }
        else
      if (low_nibble==0x06)
      {
        if (opcode==0xa6) // LDX (Zero Page)
        {
          if (debug==1) System.out.println(PC + " LDX");

          M=ram[++PC];
          X=ram[M];

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0xb6) // LDX (Zero Page, Y)
        {
          if (debug==1) System.out.println(PC + " LDX");

          M=ram[++PC]+Y;
          X=ram[M];

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x86) // STX (Zero Page)
        {
          if (debug==1) System.out.println(PC + " STX");

          M=ram[++PC];
          ram[M]=(char)X;
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0x96) // STX (Zero Page, Y)
        {
          if (debug==1) System.out.println(PC + " STX");

          M=ram[++PC]+Y;
          ram[M]=(char)X;
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0xe6) // INC (Zero Page)
        {
          if (debug==1) System.out.println(PC + " INC");

          M=ram[++PC];
          ram[M]++;
          if (ram[M]>255)
          { ram[M]=0; }

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+5;
        }
          else
        if (opcode==0xf6) // INC (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " INC");

          M=ram[++PC]+X;
          ram[M]++;
          if (ram[M]>255)
          { ram[M]=0; }

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0xc6) // DEC (Zero Page)
        {
          if (debug==1) System.out.println(PC + " DEC");

          M=ram[++PC];
          if (ram[M]==0)
          { ram[M]=255; }
            else
          { ram[M]--; }

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+5;
        }
          else
        if (opcode==0xd6) // DEC (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " DEC");

          M=ram[++PC]+X;
          if (ram[M]==0)
          { ram[M]=255; }
            else
          { ram[M]--; }

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x06)  // ASL (Zero Page)
        {
          if (debug==1) System.out.println(PC + " ASL");

          M=ram[++PC];
          C=(byte)((ram[M]&128)>>7);
          ram[M]=(char)((ram[M]<<1)&255);

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+5;
        }
          else
        if (opcode==0x46)  // LSR (Zero Page)
        {
          if (debug==1) System.out.println(PC + " LSR");

          M=ram[++PC];
          C=(byte)(ram[M]&1);
          ram[M]=(char)(ram[M]>>1);

          Z=ram[M];
          N=0;
          if (count_cycles==1) cycles=cycles+5;
        }
          else
        if (opcode==0x66)  // ROR (Zero Page)
        {
          if (debug==1) System.out.println(PC + " ROR");

          M=++PC;
          temp=(byte)(ram[M]&1);
          ram[M]=(char)((ram[M]>>1)+(C<<7));

          C=(byte)temp;
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+5;
        }
          else
        if (opcode==0x26)  // ROL (Zero Page)
        {
          if (debug==1) System.out.println(PC + " ROL");

          M=++PC;
          temp=(byte)(ram[M]&128);
          ram[M]=(char)((ram[M]<<1)+C);

          C=(byte)(temp>>7);
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+5;
        }
          else
        if (opcode==0x36)  // ROR (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " ROR");

          M=(++PC)+X;
          temp=(byte)(ram[M]&1);
          ram[M]=(char)((ram[M]>>1)+(C<<7));

          C=(byte)temp;
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x76)  // ROL (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " ROL");

          M=(++PC)+X;
          temp=(byte)(ram[M]&128);
          ram[M]=(char)((ram[M]<<1)+C);

          C=(byte)(temp>>7);
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x16)  // ASL (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " ASL");

          M=ram[++PC]+X;
          C=(byte)((ram[M]&128)>>7);
          ram[M]=(char)((ram[M]<<1)&255);

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x56)  // LSR (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " LSR");

          M=ram[++PC]+X;
          C=(byte)(ram[M]&1);
          ram[M]=(char)(ram[M]>>1);

          Z=ram[M];
          N=0;
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        {
          illegal_instruction();
          break;
        }
      }
        else
      if (low_nibble==0x05)
      {
        if (opcode==0xa5) // LDA (Zero Page)
        {
          if (debug==1) System.out.println(PC + " LDA");

          M=ram[++PC];
          A=ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0xb5) // LDA (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " LDA");

          M=ram[++PC]+X;
          A=ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x85) // STA (Zero Page)
        {
          if (debug==1) System.out.println(PC + " STA");

          M=ram[++PC];
          ram[M]=(char)A;
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0x95) // STA (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " STA");

          M=ram[++PC]+X;
          ram[M]=(char)A;
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0xc5)  // CMP (Zero Page)
        {
          if (debug==1) System.out.println(PC + " CMP");

          M=ram[++PC];
          temp=A-ram[M];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0xd5)  // CMP (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " CMP");

          M=ram[++PC]+X;
          temp=A-ram[M];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x65) // ADC (ZeroPage)
        {
          if (debug==1) System.out.println(PC + " ADC");
          M=ram[++PC];
          A=A+ram[M]+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0x75) // ADC (ZeroPage, X)
        {
          if (debug==1) System.out.println(PC + " ADC");
          M=ram[++PC]+X;
          A=A+ram[M]+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0xe5) // SBC (Zero Page)
        {
          if (debug==1) System.out.println(PC + " SBC");
          M=ram[++PC];
          A=A-ram[M]-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0xf5) // SBC (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " SBC");
          M=ram[++PC]+X;
          A=A-ram[M]-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x25) // AND (Zero Page)
        {
          if (debug==1) System.out.println(PC + " AND");

          M=ram[++PC];
          A=A&ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0x45) // EOR (Zero Page)
        {
          if (debug==1) System.out.println(PC + " EOR");

          M=ram[++PC];
          A=A^ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0x05) // ORA (Zero Page)
        {
          if (debug==1) System.out.println(PC + " ORA");

          M=ram[++PC];
          A=A|ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0x35) // AND (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " AND");

          M=ram[++PC]+X;
          A=A&ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x55) // EOR (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " EOR");

          M=ram[++PC]+X;
          A=A^ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x15) // ORA (Zero Page, X)
        {
          if (debug==1) System.out.println(PC + " ORA");

          M=ram[++PC]+X;
          A=A|ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        {
          illegal_instruction();
          break;
        }
      }
        else
      if (low_nibble==0x00)
      {
        if (opcode==0xa0) // LDY (Immediate)
        {
          if (debug==1) System.out.println(PC + " LDY");

          Y=ram[++PC];

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if ((opcode&0x10)==0x10)
        {
          branch=(byte)ram[PC+1];

          if (opcode==0xf0)  // BEQ
          {
            if (debug==1) System.out.println(PC + " BEQ");

            if (Z==0)
            {
              PC=PC+branch;
              if (count_cycles==1)
              {
                if ((PC&255)!=((PC-branch)&255))
                { cycles=cycles+3; }
                  else
                { cycles=cycles+2; }
              }
            }
              else
            if (count_cycles==1) cycles=cycles+2;
          }
            else
          if (opcode==0xd0)  // BNE
          {
            if (debug==1) System.out.println(PC + " BNE");

            if (Z!=0)
            {
              PC=PC+branch;
              if (count_cycles==1)
              {
                if ((PC&255)!=((PC-branch)&255))
                { cycles=cycles+3; }
                  else
                { cycles=cycles+2; }
              }
            }
              else
            if (count_cycles==1) cycles=cycles+2;
          }
            else
          if (opcode==0xb0)  // BCS
          {
            if (debug==1) System.out.println(PC + " BCS");

            if (C!=0)
            {
              PC=PC+branch;
              if (count_cycles==1)
              {
                if ((PC&255)!=((PC-branch)&255))
                { cycles=cycles+3; }
                  else
                { cycles=cycles+2; }
              }
            }
              else
            if (count_cycles==1) cycles=cycles+2;
          }
            else
          if (opcode==0x90)  // BCC
          {
            if (debug==1) System.out.println(PC + " BCC");

            if (C==0)
            {
              PC=PC+branch;
              if (count_cycles==1)
              {
                if ((PC&255)!=((PC-branch)&255))
                { cycles=cycles+4; }
                  else
                { cycles=cycles+3; }
              }
            }
              else
            if (count_cycles==1) cycles=cycles+2;
          }
            else
          if (opcode==0x10)  // BPL
          {
            if (debug==1) System.out.println(PC + " BPL");

            if (N==0)
            {
              PC=PC+branch;
              if (count_cycles==1)
              {
                if ((PC&255)!=((PC-branch)&255))
                { cycles=cycles+3; }
                  else
                { cycles=cycles+2; }
              }
            }
              else
            if (count_cycles==1) cycles=cycles+2;
          }
            else
          if (opcode==0x30)  // BMI
          {
            if (debug==1) System.out.println(PC + " BMI");

            if (N!=0)
            {
              PC=PC+branch;
              if (count_cycles==1)
              {
                if ((PC&255)!=((PC-branch)&255))
                { cycles=cycles+3; }
                  else
                { cycles=cycles+2; }
              }
            }
              else
            if (count_cycles==1) cycles=cycles+2;
          }
            else
          if (opcode==0x50)  // BVC
          {
            if (debug==1) System.out.println(PC + " BVC");

            if (V==0)
            {
              PC=PC+branch;
              if (count_cycles==1)
              {
                if ((PC&255)!=((PC-branch)&255))
                { cycles=cycles+3; }
                  else
                { cycles=cycles+2; }
              }
            }
              else
            if (count_cycles==1) cycles=cycles+2;
          }
            else
          if (opcode==0x70)  // BVS
          {
            if (debug==1) System.out.println(PC + " BVS");

            if (V!=0)
            {
              PC=PC+branch;
              if (count_cycles==1)
              {
                if ((PC&255)!=((PC-branch)&255))
                { cycles=cycles+3; }
                  else
                { cycles=cycles+2; }
              }
            }
              else
            if (count_cycles==1) cycles=cycles+2;
          }
            else
          {
            illegal_instruction();
            break;
          }

          PC++;
        }
          else
        if (opcode==0xe0)  // CPX (Immediate)
        {
          if (debug==1) System.out.println(PC + " CPX");

          temp=X-ram[++PC];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xc0)  // CPY (Immediate)
        {
          if (debug==1) System.out.println(PC + " CPY");

          temp=Y-ram[++PC];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x20)  // JSR
        {
          if (debug==1) System.out.println(PC + " JSR");

          ram[SP--]=(char)(((PC+2)>>8)&(int)255);
          ram[SP--]=(char)((PC+2)&(int)255);
          PC=(ram[PC+2]<<8)+ram[PC+1];
          if (count_cycles==1) cycles=cycles+6;
          continue;
        }
          else
        if (opcode==0x60)  // RTS
        {
          if (debug==1) System.out.println(PC + " RTS");

          PC=ram[++SP];
          PC=PC+((ram[++SP])<<8);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x40)  // RTI
        {
          if (debug==1) System.out.println(PC + " RTI");

          P=ram[++SP];
          unload_P();
          PC=ram[++SP];
          PC=PC+((ram[++SP])<<8);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x00)
        { 
          if (debug==1) System.out.println(PC + " BRK");
          if (count_cycles==1) cycles=cycles+7;
          break;
        }
          else
        {
          illegal_instruction();
          break;
        }
      }
        else
      if (low_nibble==0x08)
      {
        if (opcode==0x88) // DEY (Implied)
        {
          if (debug==1) System.out.println(PC + " DEY");
          Y--;
          if (Y<0) Y=255;

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xc8) // INY (Implied)
        {
          if (debug==1) System.out.println(PC + " INY");
          Y++;
          if (Y>255) Y=0;

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xe8) // INX (Implied)
        {
          if (debug==1) System.out.println(PC + " INX");
          X++;
          if (X>255) X=0;

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x18) // CLC
        {
          if (debug==1) System.out.println(PC + " CLC");
          C=0;
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x38) // SEC
        {
          if (debug==1) System.out.println(PC + " SEC");
          C=1;
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x58) // CLI
        {
          if (debug==1) System.out.println(PC + " CLI");
          I=0;
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x78) // SEI
        {
          if (debug==1) System.out.println(PC + " SEI");
          I=1;
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xb8) // CLV
        {
          if (debug==1) System.out.println(PC + " CLV");
          V=0;
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xd8) // CLD
        {
          if (debug==1) System.out.println(PC + " CLD");
          D=0;
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xf8) // SED
        {
          if (debug==1) System.out.println(PC + " SED");
          D=1;
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x48)  // PHA
        {
          if (debug==1) System.out.println(PC + " PHA");

          ram[SP--]=(char)A;
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0x08)  // PHP
        {
          if (debug==1) System.out.println(PC + " PHP");

          load_P();
          ram[SP--]=(char)P;
          if (count_cycles==1) cycles=cycles+3;
        }
          else
        if (opcode==0x68)  // PLA
        {
          if (debug==1) System.out.println(PC + " PLA");

          A=ram[++SP];
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x28)  // PLP
        {
          if (debug==1) System.out.println(PC + " PLP");

          P=ram[++SP];
          unload_P();
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x98)  // TYA
        {
          if (debug==1) System.out.println(PC + " TYA");

          A=Y;

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xa8)  // TAY
        {
          if (debug==1) System.out.println(PC + " TAY");

          Y=A;

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        {
          illegal_instruction();
          break;
        }

      }
        else
      if (low_nibble==0x0a)
      {
        if (opcode==0xca) // DEX
        {
          if (debug==1) System.out.println(PC + " DEX");
          X--;
          if (X<0) X=255;

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x4a)  // LSR (Accumulator)
        {
          if (debug==1) System.out.println(PC + " LSR");

          C=(byte)(A&1);
          A=((A>>1)&255);

          Z=A;
          N=0;
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x0a)  // ASL (Accumulator)
        {
          if (debug==1) System.out.println(PC + " ASL");

          C=(byte)((A&128)>>7);
          A=((A<<1)&255);

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xaa)  // TAX
        {
          if (debug==1) System.out.println(PC + " TAX");

          X=A;

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xba)  // TSX
        {
          if (debug==1) System.out.println(PC + " TSX");

          X=SP;

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x8a)  // TXA
        {
          if (debug==1) System.out.println(PC + " TXA");

          A=X;

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x9a)  // TXS
        {
          if (debug==1) System.out.println(PC + " TXS");

          SP=X;
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x6a)  // ROR (Accumulator)
        {
          if (debug==1) System.out.println(PC + " ROR");

          temp=(byte)(A&1);
          A=(A>>1)+(C<<7);

          C=(byte)temp;
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0x2a)  // ROL (Accumulator)
        {
          if (debug==1) System.out.println(PC + " ROL");

          temp=(byte)(A&128);
          A=(A<<1)+C;

          C=(byte)(temp>>7);
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        if (opcode==0xea)  // NOP
        {
          if (debug==1) System.out.println(PC + " NOP");
          if (count_cycles==1) cycles=cycles+2;
        }
          else
        {
          illegal_instruction();
          break;
        }
      }
        else
      if (low_nibble==0x0c)
      {
        if (opcode==0x4c)  // JMP (Absolute)
        {
          if (debug==1) System.out.println(PC + " JMP");
          PC=ram[PC+1]+(ram[PC+2]<<8);
          if (count_cycles==1) cycles=cycles+3;
          continue;
        }
          else
        if (opcode==0x6c)  // JMP (Indirect)
        {
          if (debug==1) System.out.println(PC + " JMP");
          M=ram[PC+1]+(ram[PC+2]<<8);
          PC=ram[M]+(ram[M+1]<<8);
          if (count_cycles==1) cycles=cycles+5;
          continue;
        }
          else
        if (opcode==0xac) // LDY (Absolute)
        {
          if (debug==1) System.out.println(PC + " LDY");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          Y=ram[M];

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0xbc) // LDY (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " LDY");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+X;
          Y=ram[M];

          Z=Y;
          N=(byte)(Y&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x8c) // STY (Absolute)
        {
          if (debug==1) System.out.println(PC + " STY");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          ram[M]=(char)Y;
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0xec)  // CPX (Absolute)
        {
          if (debug==1) System.out.println(PC + " CPX");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          temp=X-ram[M];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0xcc)  // CPY (Absolute)
        {
          if (debug==1) System.out.println(PC + " CPY");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          temp=Y-ram[M];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x2c) // BIT (Absolute)
        {
          if (debug==1) System.out.println(PC + " BIT");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          temp=(A&ram[M]);

          Z=temp;
          N=(byte)(temp&128);
          V=(byte)(temp&64);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        {
          illegal_instruction();
          break;
        }
      }
        else
      if (low_nibble==0x0d)
      {
        if (opcode==0xad) // LDA (Absolute)
        {
          if (debug==1) System.out.println(PC + " LDA");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          A=ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0xbd) // LDA (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " LDA");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+X;
          A=ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x8d) // STA (Absolute)
        {
          if (debug==1) System.out.println(PC + " STA");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          ram[M]=(char)A;
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x9d) // STA (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " STA");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+X;
          ram[M]=(char)A;
          if (count_cycles==1) cycles=cycles+5;
        }
          else
        if (opcode==0xcd)  // CMP (Absolute)
        {
          if (debug==1) System.out.println(PC + " CMP");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          temp=A-ram[M];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0xdd)  // CMP (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " CMP");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+X;
          temp=A-ram[M];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x6d) // ADC (Absolute)
        {
          if (debug==1) System.out.println(PC + " ADC");
          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          A=A+ram[M]+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x7d) // ADC (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " ADC");
          M=ram[++PC];
          M=M+(ram[++PC]<<8)+X;
          A=A+ram[M]+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0xed) // SBC (Absolute)
        {
          if (debug==1) System.out.println(PC + " SBC");
          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          A=A-ram[M]-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0xfd) // SBC (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " SBC");
          M=ram[++PC];
          M=M+(ram[++PC]<<8)+X;
          A=A-ram[M]-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x2d) // AND (Absolute)
        {
          if (debug==1) System.out.println(PC + " AND");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          A=A&ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x4d) // EOR (Absolute)
        {
          if (debug==1) System.out.println(PC + " EOR");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          A=A^ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x0d) // ORA (Absolute)
        {
          if (debug==1) System.out.println(PC + " ORA");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          A=A|ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x3d) // AND (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " AND");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+X;
          A=A&ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x5d) // EOR (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " EOR");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+X;
          A=A^ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0x1d) // ORA (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " ORA");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+X;
          A=A|ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-X)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        {
          illegal_instruction();
          break;
        }
      }
        else
      if (low_nibble==0x01)
      {
        if (opcode==0xa1) // LDA ((Indirect, X))
        {
          if (debug==1) System.out.println(PC + " LDA");

          M=ram[++PC]+X;
          M=ram[M]+(ram[M+1]<<8);
          A=ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0xb1) // LDA ((Indirect), Y)
        {
          if (debug==1) System.out.println(PC + " LDA");

          M=ram[++PC];
          M=ram[M]+(ram[M+1]<<8)+Y;
          A=ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+6; }
              else
            { cycles=cycles+5; }
          }
        }
          else
        if (opcode==0x81) // STA ((Indirect, X))
        {
          if (debug==1) System.out.println(PC + " STA");

          M=ram[++PC]+X;
          M=ram[M]+(ram[M+1]<<8);
          ram[M]=(char)A;
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x91) // STA ((Indirect), Y)
        {
          if (debug==1) System.out.println(PC + " STA");

          M=ram[++PC];
          M=ram[M]+(ram[M+1]<<8)+Y;
          ram[M]=(char)A;
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0xc1)  // CMP ((Indirect, X))
        {
          if (debug==1) System.out.println(PC + " CMP");

          M=ram[++PC]+X;
          M=ram[M]+(ram[M+1]<<8);
          temp=A-ram[M];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0xd1)  // CMP ((Indirect), Y)
        {
          if (debug==1) System.out.println(PC + " CMP");

          M=ram[++PC];
          M=ram[M]+(ram[M+1]<<8)+Y;
          temp=A-ram[M];
          if (temp<0)
          {
            temp=temp+256;
            C=1;
          }
            else
          { C=0; }

          Z=temp;
          N=(byte)(temp&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+6; }
              else
            { cycles=cycles+5; }
          }
        }
          else
        if (opcode==0x61) // ADC ((Indirect, X))
        {
          if (debug==1) System.out.println(PC + " ADC");
          M=ram[++PC]+X;
          M=ram[M]+(ram[M+1]<<8);
          A=A+ram[M]+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x71) // ADC ((Indirect, Y))
        {
          if (debug==1) System.out.println(PC + " ADC");
          M=ram[++PC];
          M=ram[M]+(ram[M+1]<<8)+Y;
          A=A+ram[M]+C;
          if (A>255)
          {
            C=1;
            A=A-256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+6; }
              else
            { cycles=cycles+5; }
          }
        }
          else
        if (opcode==0xe1) // SBC ((Indirect, X))
        {
          if (debug==1) System.out.println(PC + " SBC");

          M=ram[++PC]+X;
          M=ram[M]+(ram[M+1]<<8);
          A=A-ram[M]-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0xf1) // SBC ((Indirect), Y)
        {
          if (debug==1) System.out.println(PC + " SBC");

          M=ram[++PC];
          M=ram[M]+(ram[M+1]<<8)+Y;
          A=A-ram[M]-(C^1);
          if (A<0)
          {
            C=1;
            A=A+256;
          }
            else
          { C=0; }

          Z=A;
          N=(byte)(A&128);
          V=(byte)(C^N);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+6; }
              else
            { cycles=cycles+5; }
          }
        }
          else
        if (opcode==0x21) // AND ((Indirect, X))
        {
          if (debug==1) System.out.println(PC + " AND");
          M=ram[++PC]+X;
          M=ram[M]+(ram[M+1]<<8);
          A=A&ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x41) // EOR ((Indirect, X))
        {
          if (debug==1) System.out.println(PC + " EOR");
          M=ram[++PC]+X;
          M=ram[M]+(ram[M+1]<<8);
          A=A^ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x01) // ORA ((Indirect, X))
        {
          if (debug==1) System.out.println(PC + " ORA");
          M=ram[++PC]+X;
          M=ram[M]+(ram[M+1]<<8);
          A=A|ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x31) // AND ((Indirect, Y))
        {
          if (debug==1) System.out.println(PC + " AND");
          M=ram[++PC];
          M=ram[M]+(ram[M+1]<<8)+Y;
          A=A&ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+6; }
              else
            { cycles=cycles+5; }
          }
        }
          else
        if (opcode==0x51) // EOR ((Indirect, Y))
        {
          if (debug==1) System.out.println(PC + " EOR");
          M=ram[++PC];
          M=ram[M]+(ram[M+1]<<8)+Y;
          A=A^ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+6; }
              else
            { cycles=cycles+5; }
          }
        }
          else
        if (opcode==0x11) // ORA ((Indirect), Y)
        {
          if (debug==1) System.out.println(PC + " ORA");
          M=ram[++PC];
          M=ram[M]+(ram[M+1]<<8)+Y;
          A=A|ram[M];

          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+5;
        }
          else
        {
          illegal_instruction();
          break;
        }
      }
        else
      if (low_nibble==0x0e)
      {
        if (opcode==0xae) // LDX (Absolute)
        {
          if (debug==1) System.out.println(PC + " LDX");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          X=ram[M];

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0xbe) // LDX (Absolute, Y)
        {
          if (debug==1) System.out.println(PC + " LDX");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+Y;
          X=ram[M];

          Z=X;
          N=(byte)(X&128);
          if (count_cycles==1)
          {
            if ((M&255)!=((M-Y)&255))
            { cycles=cycles+5; }
              else
            { cycles=cycles+4; }
          }
        }
          else
        if (opcode==0xee) // INC (Absolute)
        {
          if (debug==1) System.out.println(PC + " INC");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          ram[M]++;
          if (ram[M]>255)
          { ram[M]=0; }

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0xfe) // INC (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " INC");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+X;
          ram[M]++;
          if (ram[M]>255)
          { ram[M]=0; }

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+7;
        }
          else
        if (opcode==0xce) // DEC (Absolute)
        {
          if (debug==1) System.out.println(PC + " DEC");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          if (ram[M]==0)
          { ram[M]=255; }
            else
          { ram[M]--; }

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0xde) // DEC (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " DEC");

          M=ram[++PC];
          M=M+(ram[++PC]<<8)+X;
          if (ram[M]==0)
          { ram[M]=255; }
            else
          { ram[M]--; }

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+7;
        }
          else
        if (opcode==0x8e) // STX (Absolute)
        {
          if (debug==1) System.out.println(PC + " STX");

          M=ram[++PC];
          M=M+(ram[++PC]<<8);
          ram[M]=(char)X;
          if (count_cycles==1) cycles=cycles+4;
        }
          else
        if (opcode==0x0e)  // ASL (Absolute)
        {
          if (debug==1) System.out.println(PC + " ASL");

          M=ram[++PC];
          M=(ram[++PC]<<8);
          C=(byte)((ram[M]&128)>>7);
          ram[M]=(char)((ram[M]<<1)&255);

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x4e)  // LSR (Absolute)
        {
          if (debug==1) System.out.println(PC + " LSR");

          M=ram[++PC];
          M=(ram[++PC]<<8);
          C=(byte)(ram[M]&1);
          ram[M]=(char)(ram[M]>>1);

          Z=ram[M];
          N=0;
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x1e)  // ASL (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " ASL");

          M=ram[++PC];
          M=(ram[++PC]<<8)+X;
          C=(byte)((ram[M]&128)>>7);
          ram[M]=(char)((ram[M]<<1)&255);

          Z=ram[M];
          N=(byte)(ram[M]&128);
          if (count_cycles==1) cycles=cycles+7;
        }
          else
        if (opcode==0x5e)  // LSR (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " LSR");

          M=ram[++PC];
          M=(ram[++PC]<<8)+X;
          C=(byte)(ram[M]&1);
          ram[M]=(char)(ram[M]>>1);

          Z=ram[M];
          N=0;
          if (count_cycles==1) cycles=cycles+7;
        }
          else
        if (opcode==0x2e)  // ROR (Absolute)
        {
          if (debug==1) System.out.println(PC + " ROR");

          M=(++PC);
          M=M+((++PC)<<8);
          temp=(byte)(ram[M]&1);
          ram[M]=(char)((ram[M]>>1)+(C<<7));

          C=(byte)temp;
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x6e)  // ROL (Absolute)
        {
          if (debug==1) System.out.println(PC + " ROL");

          M=(++PC);
          M=M+((++PC)<<8);
          temp=(byte)(ram[M]&128);
          ram[M]=(char)((ram[M]<<1)+C);

          C=(byte)(temp>>7);
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+6;
        }
          else
        if (opcode==0x3e)  // ROR (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " ROR");

          M=(++PC);
          M=M+((++PC)<<8)+X;
          temp=(byte)(ram[M]&1);
          ram[M]=(char)((ram[M]>>1)+(C<<7));

          C=(byte)temp;
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+7;
        }
          else
        if (opcode==0x7e)  // ROL (Absolute, X)
        {
          if (debug==1) System.out.println(PC + " ROL");

          M=(++PC);
          M=M+((++PC)<<8)+X;
          temp=(byte)(ram[M]&128);
          ram[M]=(char)((ram[M]<<1)+C);

          C=(byte)(temp>>7);
          Z=A;
          N=(byte)(A&128);
          if (count_cycles==1) cycles=cycles+7;
        }
          else
        {
          illegal_instruction();
          break;
        }
      }
        else
      {
        illegal_instruction();
        break;
      }

      PC++;
      if (count_cycles==1) cycles++;

if (debug==1) dump_flags();
    }

    dump_flags();

    if (debug==1)
    {
      System.out.println("Execution has ended");
    }
  }
}


