
  processor 6502

VSYNC = $00
VBLANK = $01
WSYNC = $02

  org $F000

start:
  sei
  cld

  ldx #$ff
  txs
  lda #$00
clear_tia:
  sta $00,x
  dex
  bne clear_tia

  lda #$80
  sta $0d
  lda #$01
  sta $0f

main:
  lda #$07
  sta $09      ; set color to grey

  ;; 3 lines of vsync
  lda #$02
  sta VSYNC
  sta WSYNC
  sta WSYNC 
  sta WSYNC
  lda #$00
  sta VSYNC

  ;; 37 lines of vblank
  ldx #37
vblank_loop:
  sta WSYNC
  dex
  bne vblank_loop

  lda #$00   ; clear VBLANK
  sta VBLANK

  ;; 100 lines of black
  ldx #100
black_loop:
  sta $02    ; WSYNC
  dex
  bne black_loop

  lda #$1F
  sta $09     ; set color to other

  ;; 122 lines of other
  ldx #121 ;; why isn't this 122?
other_loop:
  sta WSYNC
  dex
  bne other_loop

  lda #$02   ; set VBLANK
  sta VBLANK

  ;; 30 lines of overscan
  ldx #30
overscan_loop:
  sta WSYNC
  dex
  bne overscan_loop

  jmp main

  org $fffc
  .word start
  .word start


