#!/usr/bin/perl

use KohnBMP;
use Math::Complex;

use strict;
use warnings;

print "\nPerlMandel - Mandelbrots generated in Perl\n";
print "Copyright 2008 - Michael Kohn";
print "mike\@mikekohn.net - http://www.mikekohn.net/\n";

# Changing the values below will change the resulting image

my $image_width=640;
my $image_height=480;

my $start_real=-2.00;
my $start_imag=-1.00;
my $end_real=1.00;
my $end_imag=1.00;

my $my_bmp=new KohnBMP("out.bmp",$image_width,$image_height,3);

my @colors = ( [0,0,0], [255,0,0], [127,0,0], 
             [127,127,0], [0,127,0], [0,255,0],
             [0,255,0], [0,255,127], [0,127,127],
             [0,127,255], [0,0,255], [127,0,255],
             [127,0,255], [255,0,255], [255,0,127],
             [127,127,0], [255,0,0] );


my $inc_real=($end_real-$start_real)/$image_width;
my $inc_imag=($end_imag-$start_imag)/$image_height;

my $start=Math::Complex->make($start_real,$start_imag);
my $end=Math::Complex->make($end_real,$end_imag);
my $z;
my $count;
my $c;

print $start."  ".$end;

for (my $y=0; $y<$image_height; $y++)
{
  print $y."/".$image_height."\n";

  for (my $x=0; $x<$image_width; $x++)
  {
    $c=Math::Complex->make($start_real+($inc_real*$x),$start_imag+($inc_imag*$y));
    $z=Math::Complex->make(0,0);
    $count=169;

    while ($count>0)
    {
      $z=($z**2)+$c;
      last if (abs($z)>2);

      $count--;
    }

    $c=int($count/10);

    $my_bmp->write_pixel($colors[$c][0],$colors[$c][1],$colors[$c][2]);
  }
}

$my_bmp->close();



