/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class Boat {
    Image horizImage;
    Image vertImage;
    int holes;
    int hit_count;
    int[] hits;
    int rotate;
    int sunk;
    int x;
    int y;
    int comp_rotate;

    public Boat(String string, int n) {
        if (string != null) {
            try {
                this.horizImage = Image.createImage((String)("/" + string + "h.png"));
                this.vertImage = Image.createImage((String)("/" + string + "v.png"));
            }
            catch (Exception exception) {
                System.out.println("Boat(" + string + ") Error: " + exception.toString());
            }
        }
        this.holes = n;
        this.reset();
    }

    public int reset() {
        this.hits = new int[this.holes];
        for (int i = 0; i < this.holes; ++i) {
            this.hits[i] = 0;
        }
        this.comp_rotate = -1;
        this.hit_count = 0;
        this.rotate = 0;
        this.sunk = 0;
        this.x = 0;
        this.y = 0;
        return 0;
    }

    public boolean isHit(int n, int n2, boolean bl) {
        if (this.rotate == 0) {
            if (n >= this.x && n < this.x + this.holes && n2 == this.y) {
                if (bl) {
                    int n3 = n - this.x;
                    this.hits[n3] = 1;
                    ++this.hit_count;
                    if (this.hit_count == this.holes) {
                        this.sunk = 1;
                    }
                }
                return true;
            }
        } else if (n2 >= this.y && n2 < this.y + this.holes && n == this.x) {
            if (bl) {
                int n4 = n2 - this.y;
                this.hits[n4] = 1;
                ++this.hit_count;
                if (this.hit_count == this.holes) {
                    this.sunk = 1;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isSunk() {
        return this.sunk == 1;
    }

    public boolean isTouching(Boat boat) {
        if (this.rotate == 0) {
            for (int i = this.x; i < this.x + this.holes; ++i) {
                if (!boat.isHit(i, this.y, false)) continue;
                return true;
            }
        } else {
            for (int i = this.y; i < this.y + this.holes; ++i) {
                if (!boat.isHit(this.x, i, false)) continue;
                return true;
            }
        }
        return false;
    }
}

