/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas
extends Canvas
implements Runnable {
    Random myRandom;
    int width;
    int height;
    int playheight;
    int playBoardOffsetY;
    int compBoardOffsetY;
    int scrollY;
    Image backImage;
    Image cursorImage;
    Image offScreenImage;
    Image fireImage;
    Image splashImage;
    Image redPegImage;
    Graphics offScreengg;
    int[] playerBoard = new int[100];
    int[] compBoard = new int[100];
    int state;
    int cursorx;
    int cursory;
    Boat[] playerBoats = new Boat[5];
    Boat[] compBoats = new Boat[5];
    int debug = 1;
    int showScreen;
    Thread myThread;
    int scrolling;

    public GameCanvas() {
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.myRandom = new Random();
        try {
            this.backImage = Image.createImage((String)"/Ocean.png");
            this.cursorImage = Image.createImage((String)"/Cursor.png");
            this.fireImage = Image.createImage((String)"/Fire.png");
            this.splashImage = Image.createImage((String)"/WhitePeg.png");
            this.redPegImage = Image.createImage((String)"/RedPeg.png");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception.toString());
        }
        this.playerBoats[0] = new Boat("AirCraftCarrier", 5);
        this.playerBoats[1] = new Boat("Gunship", 3);
        this.playerBoats[2] = new Boat("Submarine", 3);
        this.playerBoats[3] = new Boat("PatrolBoat", 2);
        this.playerBoats[4] = new Boat("Destroyer", 4);
        this.compBoats[0] = new Boat(null, 5);
        this.compBoats[1] = new Boat(null, 3);
        this.compBoats[2] = new Boat(null, 3);
        this.compBoats[3] = new Boat(null, 2);
        this.compBoats[4] = new Boat(null, 4);
        this.compBoardOffsetY = this.height / 2 - (this.backImage.getHeight() * 2 + 4) / 2;
        this.scrollY = 0;
        this.playheight = this.height;
        if (this.playheight < this.backImage.getHeight() * 2 + 4) {
            this.compBoardOffsetY = 0;
            this.playheight = this.backImage.getHeight() * 2 + 4;
            this.compBoardOffsetY = 0;
        }
        this.playBoardOffsetY = this.compBoardOffsetY + this.backImage.getHeight() + 4;
        this.offScreenImage = Image.createImage((int)this.width, (int)this.height);
        this.offScreengg = this.offScreenImage.getGraphics();
        this.state = -1;
        this.offScreengg.setColor(0, 20, 0);
        this.offScreengg.fillRect(0, 0, this.width, this.height);
        this.offScreengg.setColor(255, 255, 255);
        this.centerText(this.offScreengg, "Battleship", 10);
        this.centerText(this.offScreengg, "www.mikekohn.net", 23);
        this.offScreengg.setColor(0, 255, 255);
        this.centerText(this.offScreengg, "Programming By", 40);
        this.centerText(this.offScreengg, "Michael Kohn", 53);
        this.offScreengg.setColor(255, 0, 255);
        this.centerText(this.offScreengg, "Graphics By", 70);
        this.centerText(this.offScreengg, "Matt Talbert", 83);
        this.showScreen = 1;
        this.scrolling = 0;
        this.repaint();
        this.myThread = new Thread(this);
        this.myThread.start();
    }

    public void centerText(Graphics graphics, String string, int n) {
        graphics.drawString(string, this.width / 2 - Font.getDefaultFont().stringWidth(string) / 2, n, 0);
    }

    public void run() {
        int n = 1;
        while (true) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                System.out.println(exception.toString());
            }
            if (n == this.showScreen) continue;
            n = this.showScreen;
            this.scrollScreen(this.showScreen);
        }
    }

    public void scrambleBoard() {
        this.myRandom.setSeed(System.currentTimeMillis());
        block0: for (int i = 0; i < 5; ++i) {
            int n;
            int n2;
            this.compBoats[i].rotate = this.myRandom.nextInt() % 2;
            if (this.compBoats[i].rotate < 0) {
                this.compBoats[i].rotate = -this.compBoats[i].rotate;
            }
            if (this.compBoats[i].rotate == 0) {
                n2 = this.compBoats[i].holes;
                n = 0;
            } else {
                n2 = 0;
                n = this.compBoats[i].holes;
            }
            this.compBoats[i].x = this.myRandom.nextInt() % (10 - n2);
            this.compBoats[i].y = this.myRandom.nextInt() % (10 - n);
            if (this.compBoats[i].x < 0) {
                this.compBoats[i].x = -this.compBoats[i].x;
            }
            if (this.compBoats[i].y < 0) {
                this.compBoats[i].y = -this.compBoats[i].y;
            }
            for (int j = 0; j < i; ++j) {
                if (!this.compBoats[i].isTouching(this.compBoats[j])) continue;
                --i;
                continue block0;
            }
        }
    }

    public void scrollScreen(int n) {
        this.scrolling = 1;
        if (n == 0) {
            int n2 = this.playheight - this.height;
            this.scrollY = 0;
            while (this.scrollY < n2) {
                this.updateOffscreen();
                this.repaint();
                this.scrollY += 4;
            }
            --this.scrollY;
        } else {
            this.scrollY = this.playheight - this.height;
            while (this.scrollY >= 0) {
                this.updateOffscreen();
                this.repaint();
                this.scrollY -= 4;
            }
            this.scrollY = 0;
        }
        this.scrolling = 0;
        this.updateOffscreen();
        this.repaint();
    }

    public void updateOffscreen() {
        int n;
        int n2;
        int n3;
        this.offScreengg.setColor(0, 100, 0);
        this.offScreengg.fillRect(0, 0, this.width, this.height);
        int n4 = this.width / 2 - this.backImage.getWidth() / 2;
        int n5 = this.playBoardOffsetY - this.scrollY;
        this.offScreengg.drawImage(this.backImage, n4, n5, 0);
        for (n3 = 0; n3 < this.state + 1 && n3 != 5; ++n3) {
            if (this.playerBoats[n3].rotate == 0) {
                this.offScreengg.drawImage(this.playerBoats[n3].horizImage, n4 + this.playerBoats[n3].x * 12 - 1, n5 + this.playerBoats[n3].y * 12 - 1, 0);
                continue;
            }
            this.offScreengg.drawImage(this.playerBoats[n3].vertImage, n4 + this.playerBoats[n3].x * 12 - 1, n5 + this.playerBoats[n3].y * 12 - 1, 0);
        }
        if (this.scrolling == 0) {
            for (n3 = 0; n3 < 100; ++n3) {
                if (this.playerBoard[n3] == 1) {
                    n2 = n3 % 10;
                    n = n3 / 10;
                    this.offScreengg.drawImage(this.fireImage, n4 + n2 * 12 - 1, n5 + n * 12 - 1, 0);
                    continue;
                }
                if (this.playerBoard[n3] == -1) {
                    n2 = n3 % 10;
                    n = n3 / 10;
                    this.offScreengg.drawImage(this.splashImage, n4 + n2 * 12 - 1, n5 + n * 12 - 1, 0);
                    continue;
                }
                if (this.playerBoard[n3] != 2) continue;
                n2 = n3 % 10;
                n = n3 / 10;
                this.offScreengg.drawImage(this.redPegImage, n4 + n2 * 12 - 1, n5 + n * 12 - 1, 0);
            }
        }
        n5 = this.compBoardOffsetY - this.scrollY;
        this.offScreengg.drawImage(this.backImage, n4, n5, 0);
        if (this.state == 5) {
            this.offScreengg.drawImage(this.cursorImage, n4 + this.cursorx * 12 - 1, n5 + this.cursory * 12 - 1, 0);
        }
        for (n3 = 0; n3 < 5; ++n3) {
            if (!this.compBoats[n3].isSunk()) continue;
            if (this.compBoats[n3].rotate == 0) {
                this.offScreengg.drawImage(this.playerBoats[n3].horizImage, n4 + this.compBoats[n3].x * 12 - 1, n5 + this.compBoats[n3].y * 12 - 1, 0);
                continue;
            }
            this.offScreengg.drawImage(this.playerBoats[n3].vertImage, n4 + this.compBoats[n3].x * 12 - 1, n5 + this.compBoats[n3].y * 12 - 1, 0);
        }
        if (this.scrolling == 0) {
            for (n3 = 0; n3 < 100; ++n3) {
                if (this.compBoard[n3] == 1) {
                    n2 = n3 % 10;
                    n = n3 / 10;
                    this.offScreengg.drawImage(this.fireImage, n4 + n2 * 12 - 1, n5 + n * 12 - 1, 0);
                    continue;
                }
                if (this.compBoard[n3] == -1) {
                    n2 = n3 % 10;
                    n = n3 / 10;
                    this.offScreengg.drawImage(this.splashImage, n4 + n2 * 12 - 1, n5 + n * 12 - 1, 0);
                    continue;
                }
                if (this.compBoard[n3] != 2) continue;
                n2 = n3 % 10;
                n = n3 / 10;
                this.offScreengg.drawImage(this.redPegImage, n4 + n2 * 12 - 1, n5 + n * 12 - 1, 0);
            }
        }
        if (this.state < -1) {
            this.offScreengg.setColor(0, 0, 0);
            this.offScreengg.fillRect(n4, this.height / 2 - 20, this.backImage.getWidth(), 40);
            this.offScreengg.setColor(255, 255, 255);
            if (this.state == -2) {
                this.centerText(this.offScreengg, "YOU WIN!", this.height / 2);
            } else if (this.state == -3) {
                this.centerText(this.offScreengg, "YOU LOSE!", this.height / 2);
            }
        }
    }

    public void drawBoardSunk(int[] nArray, Boat boat) {
        if (boat.rotate == 0) {
            int n = boat.x + boat.y * 10;
            for (int i = 0; i < boat.holes; ++i) {
                nArray[i + n] = 2;
            }
        } else {
            int n = boat.x + boat.y * 10;
            for (int i = 0; i < boat.holes; ++i) {
                nArray[n] = 2;
                n += 10;
            }
        }
    }

    public void strikeShip(int n, int n2) {
        for (int i = 0; i < 5; ++i) {
            if (this.playerBoats[i].isHit(n, n2, true)) {
                this.playerBoard[n + 10 * n2] = 1;
                if (!this.playerBoats[i].isSunk()) break;
                this.drawBoardSunk(this.playerBoard, this.playerBoats[i]);
                break;
            }
            this.playerBoard[n + n2 * 10] = -1;
        }
    }

    public void targetShip(int n, int n2) {
        int n3;
        if (n > 0 && this.playerBoard[n - 1 + n2 * 10] == 1 || n < 9 && this.playerBoard[n + 1 + n2 * 10] == 1) {
            int n4;
            for (n4 = n - 1; n4 >= 0; --n4) {
                if (this.playerBoard[n4 + n2 * 10] == 0) {
                    this.strikeShip(n4, n2);
                    return;
                }
                if (this.playerBoard[n4 + n2 * 10] != 1) break;
            }
            for (n4 = n + 1; n4 <= 9; ++n4) {
                if (this.playerBoard[n4 + n2 * 10] == 0) {
                    this.strikeShip(n4, n2);
                    return;
                }
                if (this.playerBoard[n4 + n2 * 10] != 1) break;
            }
        }
        if (n2 > 0 && this.playerBoard[n + (n2 - 1) * 10] == 1 || n2 < 9 && this.playerBoard[n + (n2 + 1) * 10] == 1) {
            int n5;
            for (n5 = n2 - 1; n5 >= 0; --n5) {
                if (this.playerBoard[n + n5 * 10] == 0) {
                    this.strikeShip(n, n5);
                    return;
                }
                if (this.playerBoard[n + n5 * 10] != 1) break;
            }
            for (n5 = n2 + 1; n5 <= 9; ++n5) {
                if (this.playerBoard[n + n5 * 10] == 0) {
                    this.strikeShip(n, n5);
                    return;
                }
                if (this.playerBoard[n + n5 * 10] != 1) break;
            }
        }
        if ((n3 = this.myRandom.nextInt() % 4) < 0) {
            n3 = -n3;
        }
        int n6 = 0;
        do {
            if (n3 == 0 && n - 1 >= 0 && this.playerBoard[n - 1 + n2 * 10] == 0) {
                this.strikeShip(n - 1, n2);
                break;
            }
            if (n3 == 1 && n + 1 <= 9 && this.playerBoard[n + 1 + n2 * 10] == 0) {
                this.strikeShip(n + 1, n2);
                break;
            }
            if (n3 == 2 && n2 - 1 >= 0 && this.playerBoard[n + (n2 - 1) * 10] == 0) {
                this.strikeShip(n, n2 - 1);
                break;
            }
            if (n3 == 3 && n2 + 1 <= 9 && this.playerBoard[n + (n2 + 1) * 10] == 0) {
                this.strikeShip(n, n2 + 1);
                break;
            }
            ++n6;
            if (++n3 != 4) continue;
            n3 = 0;
        } while (n6 != 5);
    }

    public void keyPressed(int n) {
        int n2;
        if (this.state < 0) {
            this.showScreen = 0;
            for (n2 = 0; n2 < 100; ++n2) {
                this.playerBoard[n2] = 0;
                this.compBoard[n2] = 0;
            }
            this.cursorx = 3;
            this.cursory = 5;
            for (n2 = 0; n2 < 5; ++n2) {
                this.playerBoats[n2].reset();
                this.compBoats[n2].reset();
            }
            this.playerBoats[0].x = this.cursorx;
            this.playerBoats[0].y = this.cursory;
            this.scrambleBoard();
            if (this.state == -1) {
                this.state = 0;
                return;
            }
            this.state = 0;
        }
        if ((n == -3 || n == 52) && this.state < 6) {
            --this.cursorx;
        } else if ((n == -2 || n == 56) && this.state < 6) {
            ++this.cursory;
        } else if ((n == -4 || n == 54) && this.state < 6) {
            ++this.cursorx;
        } else if ((n == -1 || n == 50) && this.state < 6) {
            --this.cursory;
        } else if (n == 42 && this.state >= 0 && this.state <= 4) {
            this.playerBoats[this.state].rotate ^= 1;
        } else if ((n == -5 || n == 53) && this.state >= 0 && this.state <= 4) {
            boolean bl = false;
            for (n2 = 0; n2 < this.state; ++n2) {
                if (!this.playerBoats[this.state].isTouching(this.playerBoats[n2])) continue;
                bl = true;
            }
            if (!bl) {
                ++this.state;
            }
        } else if ((n == -5 || n == 53) && this.state == 5 && this.compBoard[this.cursorx + 10 * this.cursory] == 0) {
            for (n2 = 0; n2 < 5; ++n2) {
                if (this.compBoats[n2].isHit(this.cursorx, this.cursory, true)) {
                    this.compBoard[this.cursorx + 10 * this.cursory] = 1;
                    if (!this.compBoats[n2].isSunk()) break;
                    this.drawBoardSunk(this.compBoard, this.compBoats[n2]);
                    break;
                }
                this.compBoard[this.cursorx + 10 * this.cursory] = -1;
            }
            for (n2 = 0; n2 < 5 && this.compBoats[n2].isSunk(); ++n2) {
            }
            this.state = n2 == 5 ? -2 : 6;
        }
        if (this.state >= 0 && this.state <= 4) {
            if (this.playerBoats[this.state].rotate == 0) {
                if (this.cursorx > 10 - this.playerBoats[this.state].holes) {
                    this.cursorx = 10 - this.playerBoats[this.state].holes;
                }
                if (this.cursorx < 0) {
                    this.cursorx = 0;
                }
                if (this.cursory > 9) {
                    this.cursory = 9;
                }
                if (this.cursory < 0) {
                    this.cursory = 0;
                }
            } else {
                if (this.cursorx > 9) {
                    this.cursorx = 9;
                }
                if (this.cursorx < 0) {
                    this.cursorx = 0;
                }
                if (this.cursory > 10 - this.playerBoats[this.state].holes) {
                    this.cursory = 10 - this.playerBoats[this.state].holes;
                }
                if (this.cursory < 0) {
                    this.cursory = 0;
                }
            }
            this.playerBoats[this.state].x = this.cursorx;
            this.playerBoats[this.state].y = this.cursory;
        } else if (this.state == 5) {
            this.showScreen = 1;
            if (this.cursorx > 9) {
                this.cursorx = 9;
            }
            if (this.cursorx < 0) {
                this.cursorx = 0;
            }
            if (this.cursory > 9) {
                this.cursory = 9;
            }
            if (this.cursory < 0) {
                this.cursory = 0;
            }
        } else if (this.state == 6) {
            ++this.state;
        } else if (this.state == 7) {
            int n3;
            int n4;
            this.showScreen = 0;
            for (n2 = 0; n2 < 100; ++n2) {
                if (this.playerBoard[n2] != 1) continue;
                n4 = n2 % 10;
                n3 = n2 / 10;
                this.targetShip(n4, n3);
                break;
            }
            if (n2 == 100) {
                n2 = this.myRandom.nextInt() % 100;
                if (n2 < 0) {
                    n2 = -n2;
                }
                while (this.playerBoard[n2] != 0) {
                    if (++n2 < 100) continue;
                    n2 = 0;
                }
                n4 = n2 % 10;
                n3 = n2 / 10;
                this.strikeShip(n4, n3);
            }
            for (n2 = 0; n2 < 5 && this.playerBoats[n2].isSunk(); ++n2) {
            }
            this.state = n2 == 5 ? -3 : ++this.state;
        } else if (this.state == 8) {
            this.showScreen = 1;
            this.state = 5;
        }
        this.updateOffscreen();
        this.repaint();
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.offScreenImage, 0, 0, 0);
    }
}

